/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.populator;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.ldap.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.util.Assert;

public class DefaultLdapAuthoritiesPopulator
implements LdapAuthoritiesPopulator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$ldap$populator$DefaultLdapAuthoritiesPopulator == null ? (class$org$springframework$security$ldap$populator$DefaultLdapAuthoritiesPopulator = DefaultLdapAuthoritiesPopulator.class$("org.springframework.security.ldap.populator.DefaultLdapAuthoritiesPopulator")) : class$org$springframework$security$ldap$populator$DefaultLdapAuthoritiesPopulator));
    private GrantedAuthority defaultRole;
    private ContextSource contextSource;
    private SpringSecurityLdapTemplate ldapTemplate;
    private SearchControls searchControls = new SearchControls();
    private String groupRoleAttribute = "cn";
    private String groupSearchBase;
    private String groupSearchFilter = "(member={0})";
    private String rolePrefix = "ROLE_";
    private boolean convertToUpperCase = true;
    static /* synthetic */ Class class$org$springframework$security$ldap$populator$DefaultLdapAuthoritiesPopulator;

    public DefaultLdapAuthoritiesPopulator(ContextSource contextSource, String groupSearchBase) {
        this.setContextSource(contextSource);
        this.setGroupSearchBase(groupSearchBase);
    }

    protected Set getAdditionalRoles(DirContextOperations user, String username) {
        return null;
    }

    public final GrantedAuthority[] getGrantedAuthorities(DirContextOperations user, String username) {
        String userDn = user.getNameInNamespace();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting authorities for user " + userDn));
        }
        Set roles = this.getGroupMembershipRoles(userDn, username);
        Set extraRoles = this.getAdditionalRoles(user, username);
        if (extraRoles != null) {
            roles.addAll(extraRoles);
        }
        if (this.defaultRole != null) {
            roles.add(this.defaultRole);
        }
        return roles.toArray(new GrantedAuthority[roles.size()]);
    }

    public Set getGroupMembershipRoles(String userDn, String username) {
        HashSet<GrantedAuthorityImpl> authorities = new HashSet<GrantedAuthorityImpl>();
        if (this.getGroupSearchBase() == null) {
            return authorities;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for roles for user '" + username + "', DN = " + "'" + userDn + "', with filter " + this.groupSearchFilter + " in search base '" + this.getGroupSearchBase() + "'"));
        }
        Set userRoles = this.ldapTemplate.searchForSingleAttributeValues(this.getGroupSearchBase(), this.groupSearchFilter, new String[]{userDn, username}, this.groupRoleAttribute);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Roles from search: " + userRoles));
        }
        Iterator it = userRoles.iterator();
        while (it.hasNext()) {
            String role = (String)it.next();
            if (this.convertToUpperCase) {
                role = role.toUpperCase();
            }
            authorities.add(new GrantedAuthorityImpl(this.rolePrefix + role));
        }
        return authorities;
    }

    protected ContextSource getContextSource() {
        return this.contextSource;
    }

    private void setContextSource(ContextSource contextSource) {
        Assert.notNull((Object)contextSource, (String)"contextSource must not be null");
        this.contextSource = contextSource;
        this.ldapTemplate = new SpringSecurityLdapTemplate(contextSource);
        this.ldapTemplate.setSearchControls(this.searchControls);
    }

    private void setGroupSearchBase(String groupSearchBase) {
        Assert.notNull((Object)groupSearchBase, (String)"The groupSearchBase (name to search under), must not be null.");
        this.groupSearchBase = groupSearchBase;
        if (groupSearchBase.length() == 0) {
            logger.info((Object)"groupSearchBase is empty. Searches will be performed from the context source base");
        }
    }

    protected String getGroupSearchBase() {
        return this.groupSearchBase;
    }

    public void setConvertToUpperCase(boolean convertToUpperCase) {
        this.convertToUpperCase = convertToUpperCase;
    }

    public void setDefaultRole(String defaultRole) {
        Assert.notNull((Object)defaultRole, (String)"The defaultRole property cannot be set to null");
        this.defaultRole = new GrantedAuthorityImpl(defaultRole);
    }

    public void setGroupRoleAttribute(String groupRoleAttribute) {
        Assert.notNull((Object)groupRoleAttribute, (String)"groupRoleAttribute must not be null");
        this.groupRoleAttribute = groupRoleAttribute;
    }

    public void setGroupSearchFilter(String groupSearchFilter) {
        Assert.notNull((Object)groupSearchFilter, (String)"groupSearchFilter must not be null");
        this.groupSearchFilter = groupSearchFilter;
    }

    public void setRolePrefix(String rolePrefix) {
        Assert.notNull((Object)rolePrefix, (String)"rolePrefix must not be null");
        this.rolePrefix = rolePrefix;
    }

    public void setSearchSubtree(boolean searchSubtree) {
        int searchScope = searchSubtree ? 2 : 1;
        this.searchControls.setSearchScope(searchScope);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

