/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.userdetails.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.context.ApplicationContextException;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SqlParameter;
import org.springframework.jdbc.core.support.JdbcDaoSupport;
import org.springframework.jdbc.object.MappingSqlQuery;

public class JdbcDaoImpl
extends JdbcDaoSupport
implements UserDetailsService {
    public static final String DEF_USERS_BY_USERNAME_QUERY = "SELECT username,password,enabled FROM users WHERE username = ?";
    public static final String DEF_AUTHORITIES_BY_USERNAME_QUERY = "SELECT username,authority FROM authorities WHERE username = ?";
    protected MappingSqlQuery authoritiesByUsernameMapping;
    protected MappingSqlQuery usersByUsernameMapping;
    private String authoritiesByUsernameQuery = "SELECT username,authority FROM authorities WHERE username = ?";
    private String rolePrefix = "";
    private String usersByUsernameQuery = "SELECT username,password,enabled FROM users WHERE username = ?";
    private boolean usernameBasedPrimaryKey = true;

    protected void addCustomAuthorities(String username, List authorities) {
    }

    public String getAuthoritiesByUsernameQuery() {
        return this.authoritiesByUsernameQuery;
    }

    public String getRolePrefix() {
        return this.rolePrefix;
    }

    public String getUsersByUsernameQuery() {
        return this.usersByUsernameQuery;
    }

    protected void initDao() throws ApplicationContextException {
        this.initMappingSqlQueries();
    }

    protected void initMappingSqlQueries() {
        this.usersByUsernameMapping = new UsersByUsernameMapping(this.getDataSource());
        this.authoritiesByUsernameMapping = new AuthoritiesByUsernameMapping(this.getDataSource());
    }

    public boolean isUsernameBasedPrimaryKey() {
        return this.usernameBasedPrimaryKey;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        List users = this.usersByUsernameMapping.execute(username);
        if (users.size() == 0) {
            throw new UsernameNotFoundException("User not found");
        }
        UserDetails user = (UserDetails)users.get(0);
        List dbAuths = this.authoritiesByUsernameMapping.execute(user.getUsername());
        this.addCustomAuthorities(user.getUsername(), dbAuths);
        if (dbAuths.size() == 0) {
            throw new UsernameNotFoundException("User has no GrantedAuthority");
        }
        GrantedAuthority[] arrayAuths = dbAuths.toArray(new GrantedAuthority[dbAuths.size()]);
        String returnUsername = user.getUsername();
        if (!this.usernameBasedPrimaryKey) {
            returnUsername = username;
        }
        return new User(returnUsername, user.getPassword(), user.isEnabled(), true, true, true, arrayAuths);
    }

    public void setAuthoritiesByUsernameQuery(String queryString) {
        this.authoritiesByUsernameQuery = queryString;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public void setUsernameBasedPrimaryKey(boolean usernameBasedPrimaryKey) {
        this.usernameBasedPrimaryKey = usernameBasedPrimaryKey;
    }

    public void setUsersByUsernameQuery(String usersByUsernameQueryString) {
        this.usersByUsernameQuery = usersByUsernameQueryString;
    }

    protected class UsersByUsernameMapping
    extends MappingSqlQuery {
        protected UsersByUsernameMapping(DataSource ds) {
            super(ds, JdbcDaoImpl.this.usersByUsernameQuery);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            String username = rs.getString(1);
            String password = rs.getString(2);
            boolean enabled = rs.getBoolean(3);
            User user = new User(username, password, enabled, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("HOLDER")});
            return user;
        }
    }

    protected class AuthoritiesByUsernameMapping
    extends MappingSqlQuery {
        protected AuthoritiesByUsernameMapping(DataSource ds) {
            super(ds, JdbcDaoImpl.this.authoritiesByUsernameQuery);
            this.declareParameter(new SqlParameter(12));
            this.compile();
        }

        protected Object mapRow(ResultSet rs, int rownum) throws SQLException {
            String roleName = JdbcDaoImpl.this.rolePrefix + rs.getString(2);
            GrantedAuthorityImpl authority = new GrantedAuthorityImpl(roleName);
            return authority;
        }
    }
}

