/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.test;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.chartData.AxisChartDataSet;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.DataSeries;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.ChartTypeProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.LineChartProperties;
import org.krysalis.jcharts.properties.PointChartProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.test.AxisChartTestBase;
import org.krysalis.jcharts.test.ChartTestDriver;
import org.krysalis.jcharts.test.TestDataGenerator;
import org.krysalis.jcharts.types.ChartType;

class LineTestDriver
extends AxisChartTestBase {
    LineTestDriver() {
    }

    boolean supportsImageMap() {
        return true;
    }

    static ChartTypeProperties getChartTypeProperties(int n) {
        Stroke[] strokeArray = new Stroke[n];
        for (int i = 0; i < n; ++i) {
            strokeArray[i] = LineChartProperties.DEFAULT_LINE_STROKE;
        }
        strokeArray[0] = new BasicStroke(3.0f);
        Shape[] shapeArray = new Shape[n];
        for (int i = 0; i < n; ++i) {
            shapeArray[i] = PointChartProperties.SHAPE_DIAMOND;
        }
        shapeArray[0] = PointChartProperties.SHAPE_CIRCLE;
        return new LineChartProperties(strokeArray, shapeArray);
    }

    DataSeries getDataSeries() throws ChartDataException {
        int n = (int)TestDataGenerator.getRandomNumber(3.0, 3.0);
        int n2 = (int)TestDataGenerator.getRandomNumber(1.0, 1.0);
        DataSeries dataSeries = super.createDataSeries(n);
        AxisChartDataSet axisChartDataSet = super.createAxisChartDataSet(ChartType.LINE, LineTestDriver.getChartTypeProperties(n2), n2, n, 10, 5000);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        return dataSeries;
    }

    public static void main(String[] stringArray) throws ChartDataException, PropertyException {
        LineChartProperties lineChartProperties = (LineChartProperties)LineTestDriver.getChartTypeProperties(1);
        double[][] dArrayArray = new double[][]{{280.0, 16.0, 150.0, 90.0}};
        Paint[] paintArray = new Paint[]{Color.blue};
        String[] stringArray2 = new String[]{"Test Legend Label"};
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(dArrayArray, stringArray2, paintArray, ChartType.LINE, lineChartProperties);
        String[] stringArray3 = null;
        DataSeries dataSeries = new DataSeries(stringArray3, "X-Axis Title", "Y-Axis Title", "Chart Title");
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        ChartProperties chartProperties = new ChartProperties();
        AxisProperties axisProperties = new AxisProperties(false);
        axisProperties.getYAxisProperties().setShowAxisLabels(false);
        axisProperties.getXAxisProperties().setShowAxisLabels(false);
        DataAxisProperties dataAxisProperties = (DataAxisProperties)axisProperties.getYAxisProperties();
        dataAxisProperties.setUserDefinedScale(-10.0, 50.0);
        dataAxisProperties.setNumItems(4);
        dataAxisProperties.setRoundToNearest(1);
        LegendProperties legendProperties = new LegendProperties();
        AxisChart axisChart = new AxisChart(dataSeries, chartProperties, axisProperties, legendProperties, 500, 400);
        ChartTestDriver.exportImage(axisChart, "LineChartTest.png");
    }
}

