/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class DoubleRangeValidator
implements Validator,
StateHolder {
    public static final String VALIDATOR_ID = "javax.faces.DoubleRange";
    public static final String MAXIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MAXIMUM";
    public static final String MINIMUM_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.MINIMUM";
    public static final String TYPE_MESSAGE_ID = "javax.faces.validator.DoubleRangeValidator.TYPE";
    private double maximum = Double.MAX_VALUE;
    private boolean maximumSet = false;
    private double minimum = Double.MIN_VALUE;
    private boolean minimumSet = false;
    private boolean transientValue = false;

    public DoubleRangeValidator() {
    }

    public DoubleRangeValidator(double maximum) {
        this.setMaximum(maximum);
    }

    public DoubleRangeValidator(double maximum, double minimum) {
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    public double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(double maximum) {
        this.maximum = maximum;
        this.maximumSet = true;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(double minimum) {
        this.minimum = minimum;
        this.minimumSet = true;
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (value != null) {
            try {
                double converted = this.doubleValue(value);
                if (this.maximumSet && converted > this.maximum) {
                    if (this.minimumSet) {
                        throw new ValidatorException(MessageFactory.getMessage(context, "javax.faces.validator.NOT_IN_RANGE", new Object[]{this.stringValue(component, new Double(this.minimum)), this.stringValue(component, new Double(this.maximum))}));
                    }
                    throw new ValidatorException(MessageFactory.getMessage(context, MAXIMUM_MESSAGE_ID, new Object[]{this.stringValue(component, new Double(this.maximum))}));
                }
                if (this.minimumSet && converted < this.minimum) {
                    if (this.maximumSet) {
                        throw new ValidatorException(MessageFactory.getMessage(context, "javax.faces.validator.NOT_IN_RANGE", new Object[]{this.stringValue(component, new Double(this.minimum)), this.stringValue(component, new Double(this.maximum))}));
                    }
                    throw new ValidatorException(MessageFactory.getMessage(context, MINIMUM_MESSAGE_ID, new Object[]{this.stringValue(component, new Double(this.minimum))}));
                }
            }
            catch (NumberFormatException e) {
                throw new ValidatorException(MessageFactory.getMessage(context, TYPE_MESSAGE_ID));
            }
        }
    }

    public boolean equals(Object otherObj) {
        if (!(otherObj instanceof DoubleRangeValidator)) {
            return false;
        }
        DoubleRangeValidator other = (DoubleRangeValidator)otherObj;
        return this.maximum == other.maximum && this.minimum == other.minimum && this.maximumSet == other.maximumSet && this.minimumSet == other.minimumSet;
    }

    private double doubleValue(Object attributeValue) throws NumberFormatException {
        if (attributeValue instanceof Number) {
            return ((Number)attributeValue).doubleValue();
        }
        return Double.parseDouble(attributeValue.toString());
    }

    private String stringValue(UIComponent component, Double toConvert) {
        String result = null;
        Converter converter = null;
        FacesContext context = FacesContext.getCurrentInstance();
        converter = context.getApplication().createConverter("javax.faces.Number");
        result = converter.getAsString(context, component, toConvert);
        return result;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{new Double(this.maximum), this.maximumSet ? Boolean.TRUE : Boolean.FALSE, new Double(this.minimum), this.minimumSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        this.maximum = (Double)values[0];
        this.maximumSet = (Boolean)values[1];
        this.minimum = (Double)values[2];
        this.minimumSet = (Boolean)values[3];
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }
}

