/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.client.async;

import java.security.PrivilegedAction;
import java.util.concurrent.Callable;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.client.async.AsyncResponse;
import org.apache.axis2.jaxws.core.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CallbackFutureTask
implements Callable {
    private static final Log log = LogFactory.getLog(CallbackFutureTask.class);
    private static final boolean debug = log.isDebugEnabled();
    AsyncResponse response;
    MessageContext msgCtx;
    AsyncHandler handler;
    Exception error;
    boolean done = false;

    CallbackFutureTask(AsyncResponse r, AsyncHandler h) {
        this.response = r;
        this.handler = h;
    }

    protected AsyncHandler getHandler() {
        return this.handler;
    }

    void setMessageContext(MessageContext mc) {
        this.msgCtx = mc;
    }

    void setError(Exception e) {
        this.error = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() throws Exception {
        Object classLoader;
        try {
            classLoader = (ClassLoader)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

                public Object run() {
                    return CallbackFutureTask.this.handler.getClass().getClassLoader();
                }
            });
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting up the thread's ClassLoader");
                log.debug((Object)classLoader.toString());
            }
            AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction((ClassLoader)classLoader){
                final /* synthetic */ ClassLoader val$classLoader;
                {
                    this.val$classLoader = classLoader;
                }

                public Object run() {
                    Thread.currentThread().setContextClassLoader(this.val$classLoader);
                    return null;
                }
            });
            if (this.error != null) {
                this.response.onError(this.error, this.msgCtx, (ClassLoader)classLoader);
            } else {
                this.response.onComplete(this.msgCtx, (ClassLoader)classLoader);
            }
            if (debug) {
                log.debug((Object)"Calling JAX-WS AsyncHandler with the Response object");
                log.debug((Object)("AyncHandler class: " + this.handler.getClass()));
            }
            this.handler.handleResponse((Response)this.response);
        }
        catch (Throwable t) {
            if (debug) {
                log.debug((Object)"An error occured while invoking the callback object.");
                log.debug((Object)("Error: " + t.getMessage()));
            }
        }
        finally {
            classLoader = this;
            synchronized (classLoader) {
                this.done = true;
                this.notifyAll();
            }
        }
        return null;
    }
}

