/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.language;

import de.hunsicker.jalopy.language.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class MethodType
implements Comparable,
Type {
    static final int GETTER_INT = 2;
    static final int OTHER_INT = 8;
    static final int SETTER_INT = 1;
    static final int TESTER_INT = 4;
    private static final String PREF_GET = "get";
    private static final String PREF_IS = "is";
    private static final String PREF_SET = "set";
    private static String _sortOrder;
    private static final List order;
    public static final MethodType GETTER;
    public static final MethodType SETTER;
    public static final MethodType TESTER;
    public static final MethodType OTHER;
    private final String _name;

    private MethodType(String name, int key) {
        this._name = name;
    }

    public static synchronized void setOrder(String str) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException("order == " + str);
        }
        StringTokenizer tokens = new StringTokenizer(str, ",");
        ArrayList<MethodType> temp = new ArrayList<MethodType>(order.size());
        StringBuffer buf = new StringBuffer(20);
        while (tokens.hasMoreElements()) {
            String token = tokens.nextToken();
            MethodType type = MethodType.valueOf(token);
            if (temp.contains(type)) {
                throw new IllegalArgumentException("invalid order string " + order);
            }
            temp.add(type);
            buf.append(type.toString());
            buf.append(',');
        }
        if (order.size() != temp.size()) {
            throw new IllegalArgumentException("invalid order string " + order);
        }
        if (!(temp.contains(GETTER) && temp.contains(SETTER) && temp.contains(SETTER) && temp.contains(OTHER))) {
            throw new IllegalArgumentException("invalid order string " + order);
        }
        order.clear();
        order.addAll(temp);
        buf.deleteCharAt(buf.length() - 1);
        _sortOrder = buf.toString();
    }

    public static synchronized String getOrder() {
        return _sortOrder;
    }

    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        if (other instanceof MethodType) {
            int otherIndex;
            int thisIndex = order.indexOf(this);
            if (thisIndex > (otherIndex = order.indexOf(other))) {
                return 1;
            }
            if (thisIndex < otherIndex) {
                return -1;
            }
            return 0;
        }
        throw new ClassCastException(other == null ? "null" : other.getClass().getName());
    }

    public String toString() {
        return this._name;
    }

    public static MethodType valueOf(String name) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("invalid method name " + name);
        }
        if (MethodType.isGetter(name = name.trim())) {
            return GETTER;
        }
        if (MethodType.isSetter(name)) {
            return SETTER;
        }
        if (MethodType.isTester(name)) {
            return TESTER;
        }
        return OTHER;
    }

    public boolean isBean() {
        return this == GETTER || this == SETTER || this == TESTER;
    }

    private static boolean isGetter(String name) {
        int length = name.length();
        return length > 3 && name.startsWith(PREF_GET) && Character.isUpperCase(name.charAt(3));
    }

    private static boolean isSetter(String name) {
        int length = name.length();
        return length > 3 && name.startsWith(PREF_SET) && Character.isUpperCase(name.charAt(3));
    }

    private static boolean isTester(String name) {
        int length = name.length();
        return length > 2 && name.startsWith(PREF_IS) && Character.isUpperCase(name.charAt(2));
    }

    static {
        order = new ArrayList(5);
        GETTER = new MethodType("getFoo", 2);
        SETTER = new MethodType("setFoo", 1);
        TESTER = new MethodType("isFoo", 4);
        OTHER = new MethodType("foo", 8);
        order.add(SETTER);
        order.add(GETTER);
        order.add(TESTER);
        order.add(OTHER);
        StringBuffer buf = new StringBuffer(10);
        int i = 0;
        int size = order.size();
        while (i < size) {
            buf.append(((MethodType)MethodType.order.get((int)i))._name);
            buf.append(',');
            ++i;
        }
        buf.setLength(buf.length() - 1);
        _sortOrder = buf.toString();
    }
}

