/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.Marker;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.printer.TestNodeWriter;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class ArrayInitializerPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new ArrayInitializerPrinter();

    protected ArrayInitializerPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        int maxElementsPerLine = AbstractPrinter.settings.getInt(ConventionKeys.LINE_WRAP_ARRAY_ELEMENTS, 0);
        boolean wrapAsNeeded = maxElementsPerLine == 0;
        int lineLength = AbstractPrinter.settings.getInt(ConventionKeys.LINE_LENGTH, 80);
        boolean bracesPadding = AbstractPrinter.settings.getBoolean(ConventionKeys.PADDING_BRACES, true);
        boolean spaceAfterComma = AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_AFTER_COMMA, true);
        int numElements = 0;
        int last = out.last;
        boolean multiArray = this.hasArrayChild(node);
        if (multiArray) {
            maxElementsPerLine = 1;
            wrapAsNeeded = false;
        }
        if (this.isFirstOfMultiArray((JavaNode)node)) {
            if (!out.newline) {
                out.printNewline();
            }
            this.printIndentation(out);
        }
        JavaNode firstElement = (JavaNode)node.getFirstChild();
        if (maxElementsPerLine != Integer.MAX_VALUE && out.mode == 1) {
            TestNodeWriter tester = out.testers.get();
            AST child = firstElement;
            while (child != null) {
                switch (child.getType()) {
                    case 85: {
                        break;
                    }
                    default: {
                        ++numElements;
                    }
                }
                PrinterFactory.create(child, out).print(child, tester);
                if (wrapAsNeeded && tester.length > lineLength) break;
                child = child.getNextSibling();
            }
            if (!(numElements <= maxElementsPerLine || wrapAsNeeded && out.column + tester.length <= lineLength)) {
                if (!out.newline) {
                    if (out.getIndentLength() != out.column - 1 && AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false) && ((JavaNode)node).getParent().getType() != 34) {
                        out.printNewline();
                        this.printIndentation(out);
                    } else {
                        switch (last) {
                            case 22: {
                                if (!AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACES, true)) break;
                                out.print(" ", out.last);
                            }
                        }
                    }
                }
                if (this.printCommentsBefore(node, false, out) && out.newline) {
                    this.printIndentation(out);
                }
                out.print("{", 7);
                this.printCommentsAfter(node, false, false, out);
                Marker marker = null;
                if (AbstractPrinter.settings.getBoolean(ConventionKeys.INDENT_DEEP, false)) {
                    if (!out.state.markers.isMarked()) {
                        marker = out.state.markers.add(out.line, out.column - 2);
                        out.state.markers.add(out.line, out.state.markers.getLast().column + out.indentSize);
                    } else {
                        marker = out.state.markers.add(out.line, out.state.markers.getLast().column + out.indentSize);
                    }
                } else {
                    out.indent();
                }
                boolean wrapped = false;
                if (firstElement.getType() != 34 && (!multiArray || this.hasArrayParent(node))) {
                    out.printNewline();
                    this.printIndentation(out);
                    wrapped = true;
                }
                int count = 0;
                JavaNode rcurly = null;
                JavaNode child2 = firstElement;
                while (child2 != null) {
                    switch (child2.getType()) {
                        case 85: {
                            if (!child2.hasCommentsAfter()) {
                                out.print(",", 85);
                                break;
                            }
                            out.print(",", 85);
                            wrapped = this.printCommentsAfter(child2, false, !this.isLastElement(child2), out);
                            count = 0;
                            break;
                        }
                        case 8: {
                            rcurly = child2;
                            break;
                        }
                        default: {
                            ++count;
                            if (!wrapped) {
                                int blankLines;
                                tester.reset();
                                PrinterFactory.create(child2, out).print(child2, tester);
                                if (!wrapAsNeeded && count > maxElementsPerLine || wrapAsNeeded && out.column + tester.length > lineLength) {
                                    if (!child2.hasCommentsBefore() || child2.getHiddenBefore().getLine() != child2.getStartLine()) {
                                        out.printNewline();
                                        this.printIndentation(out);
                                        wrapped = true;
                                        count = 1;
                                        blankLines = this.getOriginalBlankLines(child2);
                                        if (blankLines > 0) {
                                            out.printBlankLines(blankLines);
                                        }
                                    }
                                } else {
                                    blankLines = this.getOriginalBlankLines(child2);
                                    if (blankLines > 0) {
                                        out.printNewline();
                                        this.printIndentation(out);
                                        wrapped = true;
                                        count = 1;
                                        out.printBlankLines(blankLines);
                                    } else if (spaceAfterComma && count > 1) {
                                        out.print(" ", 175);
                                    }
                                }
                            }
                            wrapped = false;
                            PrinterFactory.create(child2, out).print(child2, out);
                        }
                    }
                    child2 = (JavaNode)child2.getNextSibling();
                }
                if (marker != null) {
                    out.state.markers.remove(marker);
                } else {
                    out.unindent();
                }
                if (!out.newline) {
                    out.printNewline();
                }
                this.printIndentation(out);
                this.printCommentsBefore(rcurly, false, out);
                out.print("}", 34);
                this.printCommentsAfter(rcurly, true, false, out);
                out.testers.release(tester);
                return;
            }
            out.testers.release(tester);
        }
        switch (last) {
            case 22: {
                if (!AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_BRACES, true)) break;
                out.print(" ", out.last);
            }
        }
        if (this.printCommentsBefore(node, false, out) && out.newline) {
            this.printIndentation(out);
            out.print("{", 7);
        } else if (bracesPadding) {
            out.print("{ ", 7);
        } else {
            out.print("{", 7);
        }
        this.printCommentsAfter(node, false, false, out);
        out.indent();
        String comma = spaceAfterComma ? ", " : ",";
        JavaNode rcurly = null;
        JavaNode child = (JavaNode)node.getFirstChild();
        while (child != null) {
            block13 : switch (child.getType()) {
                case 85: {
                    this.printCommentsBefore(child, out);
                    if (!child.hasCommentsAfter()) {
                        if (this.isLast(child)) {
                            out.print(",", 85);
                            break;
                        }
                        out.print(comma, 85);
                        break;
                    }
                    out.print(",", 85);
                    this.printCommentsAfter(child, false, true, out);
                    break;
                }
                default: {
                    switch (child.getType()) {
                        case 33: {
                            JavaNode c = (JavaNode)child.getFirstChild();
                            if (c.hasCommentsBefore()) {
                                out.printNewline();
                                this.printIndentation(out);
                                bracesPadding = false;
                            }
                            PrinterFactory.create(child, out).print(child, out);
                            if (!c.hasCommentsAfter()) break block13;
                            bracesPadding = false;
                            break block13;
                        }
                        case 8: {
                            rcurly = child;
                            if (!child.hasCommentsBefore()) break block13;
                            bracesPadding = false;
                            break block13;
                        }
                        default: {
                            PrinterFactory.create(child, out).print(child, out);
                            if (!child.hasCommentsAfter()) break block13;
                            bracesPadding = false;
                        }
                    }
                }
            }
            child = (JavaNode)child.getNextSibling();
        }
        out.unindent();
        this.printCommentsBefore(rcurly, false, out);
        if (out.newline) {
            this.printIndentation(out);
        }
        if (!out.newline && bracesPadding) {
            out.print(" }", 8);
        } else {
            out.print("}", 8);
        }
        this.printCommentsAfter(rcurly, false, false, out);
    }

    private boolean isFirstOfMultiArray(JavaNode node) {
        JavaNode parent = node.getParent();
        return parent.getType() == 34 && node.getPreviousSibling() == parent;
    }

    private boolean isLast(AST node) {
        return node.getNextSibling().getType() == 8;
    }

    private boolean isLastElement(JavaNode node) {
        AST next = node.getNextSibling();
        return next == null || next.getType() == 8;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasArrayChild(AST node) {
        AST child = node.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 34: {
                    return true;
                }
                case 33: {
                    AST child1 = child.getFirstChild();
                    switch (child1.getType()) {
                        case 168: {
                            if (!this.hasArrayChild(child1.getFirstChild())) break;
                            return true;
                        }
                    }
                    break;
                }
            }
            child = child.getNextSibling();
        }
        return false;
    }

    private boolean hasArrayParent(AST node) {
        JavaNode parent = ((JavaNode)node).getParent();
        switch (parent.getType()) {
            case 34: {
                return true;
            }
            case 168: {
                return parent.getParent().getParent().getType() == 34;
            }
        }
        return false;
    }
}

