/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.facelets;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.facelets.JspTagDetector;
import com.icesoft.faces.facelets.UIXhtmlTagDecorator;
import com.icesoft.faces.facelets.UIXhtmlTagLibrary;
import com.sun.facelets.Facelet;
import com.sun.facelets.FaceletFactory;
import com.sun.facelets.compiler.Compiler;
import com.sun.facelets.compiler.SAXCompiler;
import com.sun.facelets.compiler.TagLibraryConfig;
import com.sun.facelets.impl.DefaultFaceletFactory;
import com.sun.facelets.impl.DefaultResourceResolver;
import com.sun.facelets.impl.ResourceResolver;
import com.sun.facelets.tag.TagDecorator;
import com.sun.facelets.tag.TagLibrary;
import com.sun.facelets.tag.jsf.ComponentSupport;
import com.sun.facelets.util.ReflectionUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class D2DFaceletViewHandler
extends D2DViewHandler {
    public static final long DEFAULT_REFRESH_PERIOD = 2L;
    public static final String PARAM_REFRESH_PERIOD = "facelets.REFRESH_PERIOD";
    public static final String PARAM_SKIP_COMMENTS = "facelets.SKIP_COMMENTS";
    public static final String PARAM_VIEW_MAPPINGS = "facelets.VIEW_MAPPINGS";
    public static final String PARAM_LIBRARIES = "facelets.LIBRARIES";
    public static final String PARAM_DECORATORS = "facelets.DECORATORS";
    public static final String PARAM_RESOURCE_RESOLVER = "facelets.RESOURCE_RESOLVER";
    private static Log log = LogFactory.getLog((Class)D2DFaceletViewHandler.class);
    protected FaceletFactory faceletFactory;

    public D2DFaceletViewHandler() {
    }

    public D2DFaceletViewHandler(ViewHandler delegate) {
        super(delegate);
    }

    protected void faceletInitialize() {
        block3: {
            try {
                if (this.faceletFactory == null) {
                    SAXCompiler c = new SAXCompiler();
                    this.initializeCompiler((Compiler)c);
                    this.faceletFactory = this.createFaceletFactory((Compiler)c);
                }
            }
            catch (Throwable t) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Failed initializing facelet instance", t);
            }
        }
    }

    protected void initializeCompiler(Compiler c) {
        String paramSkipComments;
        String paramDecorators;
        FacesContext ctx = FacesContext.getCurrentInstance();
        ExternalContext ext = ctx.getExternalContext();
        c.addTagLibrary((TagLibrary)new UIXhtmlTagLibrary());
        c.addTagDecorator((TagDecorator)new UIXhtmlTagDecorator());
        c.addTagDecorator((TagDecorator)new JspTagDetector());
        String paramLibraries = ext.getInitParameter(PARAM_LIBRARIES);
        if (paramLibraries != null) {
            paramLibraries = paramLibraries.trim();
            String[] paramLibrariesArray = paramLibraries.split(";");
            for (int i = 0; i < paramLibrariesArray.length; ++i) {
                try {
                    URL url = ext.getResource(paramLibrariesArray[i]);
                    if (url == null) {
                        throw new FileNotFoundException(paramLibrariesArray[i]);
                    }
                    TagLibrary tagLibrary = TagLibraryConfig.create((URL)url);
                    c.addTagLibrary(tagLibrary);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Loaded library: " + paramLibrariesArray[i]));
                    continue;
                }
                catch (IOException e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Problem loading library: " + paramLibrariesArray[i]), (Throwable)e);
                }
            }
        }
        if ((paramDecorators = ext.getInitParameter(PARAM_DECORATORS)) != null) {
            paramDecorators = paramDecorators.trim();
            String[] paramDecoratorsArray = paramDecorators.split(";");
            for (int i = 0; i < paramDecoratorsArray.length; ++i) {
                try {
                    Class tagDecoratorClass = ReflectionUtil.forName((String)paramDecoratorsArray[i]);
                    TagDecorator tagDecorator = (TagDecorator)tagDecoratorClass.newInstance();
                    c.addTagDecorator(tagDecorator);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Loaded decorator: " + paramDecoratorsArray[i]));
                    continue;
                }
                catch (Exception e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)("Problem loading decorator: " + paramDecoratorsArray[i]), (Throwable)e);
                }
            }
        }
        if ((paramSkipComments = ext.getInitParameter(PARAM_SKIP_COMMENTS)) != null && paramSkipComments.equals("false")) {
            c.setTrimmingComments(false);
        }
        c.setTrimmingWhitespace(true);
        c.setTrimmingComments(true);
        c.setTrimmingXmlDeclarations(true);
        c.setTrimmingDoctypeDeclarations(true);
    }

    protected FaceletFactory createFaceletFactory(Compiler c) {
        FacesContext ctx;
        long refreshPeriod;
        block7: {
            refreshPeriod = 2L;
            ctx = FacesContext.getCurrentInstance();
            String paramRefreshPeriod = ctx.getExternalContext().getInitParameter(PARAM_REFRESH_PERIOD);
            if (paramRefreshPeriod != null && paramRefreshPeriod.length() > 0) {
                try {
                    refreshPeriod = Long.parseLong(paramRefreshPeriod);
                }
                catch (NumberFormatException nfe) {
                    if (!log.isWarnEnabled()) break block7;
                    log.warn((Object)("Problem parsing refresh period: " + paramRefreshPeriod), (Throwable)nfe);
                }
            }
        }
        DefaultResourceResolver resourceResolver = null;
        String paramResourceResolver = ctx.getExternalContext().getInitParameter(PARAM_RESOURCE_RESOLVER);
        if (paramResourceResolver != null && paramResourceResolver.length() > 0) {
            try {
                Class resourceResolverClass = ReflectionUtil.forName((String)paramResourceResolver);
                resourceResolver = (ResourceResolver)resourceResolverClass.newInstance();
            }
            catch (Exception e) {
                throw new FacesException("Problem initializing ResourceResolver: " + paramResourceResolver, (Throwable)e);
            }
        }
        if (resourceResolver == null) {
            resourceResolver = new DefaultResourceResolver();
        }
        resourceResolver = this.preChainResourceResolver((ResourceResolver)resourceResolver);
        return new DefaultFaceletFactory(c, (ResourceResolver)resourceResolver, refreshPeriod);
    }

    protected ResourceResolver preChainResourceResolver(ResourceResolver after) {
        return after;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderResponse(FacesContext facesContext) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"renderResponse(FC)");
        }
        BridgeFacesContext context = (BridgeFacesContext)facesContext;
        try {
            ResponseWriter responseWriter = context.createAndSetResponseWriter();
            UIViewRoot viewToRender = context.getViewRoot();
            if (viewToRender.getId() == null) {
                viewToRender.setId(viewToRender.createUniqueId());
            }
            ComponentSupport.removeTransient((UIComponent)viewToRender);
            this.faceletInitialize();
            Facelet f = null;
            FaceletFactory.setInstance((FaceletFactory)this.faceletFactory);
            try {
                f = this.faceletFactory.getFacelet(viewToRender.getViewId());
            }
            finally {
                FaceletFactory.setInstance(null);
            }
            f.apply((FacesContext)context, (UIComponent)viewToRender);
            D2DFaceletViewHandler.verifyUniqueComponentIds(context, (UIComponent)viewToRender);
            this.tracePrintComponentTree(context);
            responseWriter.startDocument();
            this.renderResponse(context, (UIComponent)viewToRender);
            this.invokeStateSaving(context);
            responseWriter.endDocument();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)("Problem in renderResponse: " + e.getMessage()), (Throwable)e);
            }
            throw new FacesException("Problem in renderResponse: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String getDefaultSuffix() {
        return ".xhtml";
    }

    protected static void removeTransient(UIComponent c) {
        UIComponent d;
        Iterator<Object> itr;
        if (c.getChildCount() > 0) {
            itr = c.getChildren().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.getFacets().size() > 0) {
                    Iterator jtr = d.getFacets().values().iterator();
                    while (jtr.hasNext()) {
                        UIComponent e = (UIComponent)jtr.next();
                        if (e.isTransient()) {
                            jtr.remove();
                            continue;
                        }
                        D2DFaceletViewHandler.removeTransient(e);
                    }
                }
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                D2DFaceletViewHandler.removeTransient(d);
            }
        }
        if (c.getFacets().size() > 0) {
            itr = c.getFacets().values().iterator();
            while (itr.hasNext()) {
                d = (UIComponent)itr.next();
                if (d.isTransient()) {
                    itr.remove();
                    continue;
                }
                D2DFaceletViewHandler.removeTransient(d);
            }
        }
    }

    protected static void verifyUniqueComponentIds(FacesContext context, UIComponent comp) {
        if (!log.isDebugEnabled()) {
            return;
        }
        HashMap ids = new HashMap(512);
        ArrayList duplicateIds = new ArrayList(256);
        D2DFaceletViewHandler.quicklyDetectDuplicateComponentIds(comp, ids, duplicateIds);
        if (!duplicateIds.isEmpty()) {
            HashMap duplicateIds2comps = new HashMap(512);
            D2DFaceletViewHandler.compileDuplicateComponentIds(comp, duplicateIds2comps, duplicateIds);
            D2DFaceletViewHandler.reportDuplicateComponentIds(context, duplicateIds2comps, duplicateIds);
        }
    }

    private static void quicklyDetectDuplicateComponentIds(UIComponent comp, HashMap ids, ArrayList duplicateIds) {
        String id = comp.getId();
        if (id == null) {
            log.debug((Object)("UIComponent has null id: " + comp));
        } else if (ids.containsKey(id)) {
            if (!duplicateIds.contains(id)) {
                duplicateIds.add(id);
            }
        } else {
            ids.put(id, id);
        }
        Iterator children = comp.getFacetsAndChildren();
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            D2DFaceletViewHandler.quicklyDetectDuplicateComponentIds(child, ids, duplicateIds);
        }
    }

    private static void compileDuplicateComponentIds(UIComponent comp, HashMap duplicateIds2comps, ArrayList duplicateIds) {
        String id = comp.getId();
        if (id != null && duplicateIds.contains(id)) {
            ArrayList<UIComponent> duplicateComps = (ArrayList<UIComponent>)duplicateIds2comps.get(id);
            if (duplicateComps == null) {
                duplicateComps = new ArrayList<UIComponent>();
                duplicateIds2comps.put(id, duplicateComps);
            }
            duplicateComps.add(comp);
        }
        Iterator children = comp.getFacetsAndChildren();
        while (children.hasNext()) {
            UIComponent child = (UIComponent)children.next();
            D2DFaceletViewHandler.compileDuplicateComponentIds(child, duplicateIds2comps, duplicateIds);
        }
    }

    private static void reportDuplicateComponentIds(FacesContext context, HashMap duplicateIds2comps, ArrayList duplicateIds) {
        int numDuplicateIds = duplicateIds.size();
        log.debug((Object)("There were " + numDuplicateIds + " ids found which are duplicates, meaning that multiple UIComponents share that same id"));
        for (int i = 0; i < numDuplicateIds; ++i) {
            String id = (String)duplicateIds.get(i);
            ArrayList duplicateComps = (ArrayList)duplicateIds2comps.get(id);
            StringBuffer sb = new StringBuffer(512);
            sb.append("Duplicate id: ");
            sb.append(id);
            sb.append(".  Number of UIComponents sharing that id: ");
            sb.append(Integer.toString(duplicateComps.size()));
            sb.append('.');
            for (int c = 0; c < duplicateComps.size(); ++c) {
                UIComponent comp = (UIComponent)duplicateComps.get(c);
                sb.append("\n  clientId: ");
                sb.append(comp.getClientId(context));
                if (comp.isTransient()) {
                    sb.append(".  TRANSIENT");
                }
                sb.append(".  component: ");
                sb.append(comp.toString());
            }
            log.debug((Object)sb.toString());
        }
    }
}

