/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ContextMethodBuilder;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.binding.def.ComponentProperty;
import org.jibx.binding.def.DefinitionContext;
import org.jibx.binding.def.DirectObject;
import org.jibx.binding.def.DirectProperty;
import org.jibx.binding.def.IComponent;
import org.jibx.binding.def.IContainer;
import org.jibx.binding.def.IContextObj;
import org.jibx.binding.def.ObjectBinding;
import org.jibx.binding.def.PassThroughComponent;
import org.jibx.binding.def.PropertyDefinition;
import org.jibx.runtime.JiBXException;

public class StructureReference
extends PassThroughComponent {
    private final IContainer m_container;
    private final IContextObj m_contextObject;
    private final PropertyDefinition m_property;
    private final String m_label;
    private boolean m_skipMarshal;
    private boolean m_needLoad;

    public StructureReference(IContainer contain, String label, PropertyDefinition prop, boolean hasname, IContextObj cobj) {
        this.m_container = contain;
        this.m_contextObject = cobj;
        this.m_property = prop;
        this.m_skipMarshal = hasname && prop != null && prop.isOptional();
        this.m_label = label;
    }

    public void genAttributeMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_needLoad) {
            mb.loadObject();
        }
        this.m_component.genAttributeMarshal(mb);
    }

    public void genContentMarshal(ContextMethodBuilder mb) throws JiBXException {
        if (this.m_needLoad) {
            mb.loadObject();
        }
        this.m_component.genContentMarshal(mb);
    }

    public void setLinkages() throws JiBXException {
        IComponent wrap;
        String itype;
        DefinitionContext defc = this.m_container.getDefinitionContext();
        IComponent impl = defc.getNamedStructure(this.m_label);
        String type = this.m_property == null ? this.m_contextObject.getBoundClass().getClassName() : this.m_property.getTypeName();
        ClassFile cf = ClassCache.getClassFile(type);
        if (!cf.isSuperclass(itype = impl.getType())) {
            throw new JiBXException("Reference to structure " + this.m_label + " has object of type " + type + " rather than required " + itype);
        }
        if (impl instanceof DirectObject) {
            wrap = new DirectProperty(this.m_property, (DirectObject)impl);
        } else if (this.m_property == null || this.m_property.isImplicit()) {
            wrap = impl;
            this.m_needLoad = impl instanceof ObjectBinding;
        } else {
            wrap = new ComponentProperty(this.m_property, impl, this.m_skipMarshal);
        }
        this.setWrappedComponent(wrap);
        this.m_component.setLinkages();
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("structure reference to " + this.m_label);
        if (this.m_property != null) {
            System.out.println(" using " + this.m_property.toString());
        }
        System.out.println();
    }
}

