/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.language.JavaNodeHelper;
import de.hunsicker.jalopy.language.antlr.JavaNode;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

class BlockPrinter
extends AbstractPrinter {
    private static final Printer INSTANCE = new BlockPrinter();

    protected BlockPrinter() {
    }

    public static Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        int closeBraceType;
        boolean leftBraceNewline;
        boolean insertEmptyStatement;
        boolean cuddleEmpty;
        boolean freestanding;
        boolean treatDifferent;
        boolean newLineAfter;
        boolean forceNewlineBefore;
        JavaNode lcurly;
        block55: {
            block56: {
                lcurly = (JavaNode)node;
                forceNewlineBefore = out.state.newlineBeforeLeftBrace;
                newLineAfter = false;
                treatDifferent = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_TREAT_DIFFERENT, false);
                if (treatDifferent) {
                    switch (lcurly.getParent().getType()) {
                        case 13: 
                        case 14: 
                        case 19: 
                        case 20: {
                            forceNewlineBefore = true;
                            break;
                        }
                        case 68: {
                            forceNewlineBefore = false;
                            treatDifferent = false;
                            break;
                        }
                        case 51: 
                        case 54: {
                            forceNewlineBefore = false;
                            break;
                        }
                        default: {
                            treatDifferent = false;
                        }
                    }
                }
                freestanding = JavaNodeHelper.isFreestandingBlock(lcurly);
                cuddleEmpty = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_EMPTY_CUDDLE, false);
                insertEmptyStatement = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_EMPTY_INSERT_STATEMENT, false);
                leftBraceNewline = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_LEFT, false);
                int n = closeBraceType = node.getType() == 12 ? 8 : 11;
                if (!JavaNodeHelper.isEmptyBlock(node)) break block55;
                if (!insertEmptyStatement) break block56;
                switch (((JavaNode)node).getParent().getType()) {
                    case 13: 
                    case 14: 
                    case 19: 
                    case 20: 
                    case 51: 
                    case 54: {
                        break block55;
                    }
                    default: {
                        this.printBracesEmptyStatement(lcurly, leftBraceNewline, forceNewlineBefore, freestanding, closeBraceType, out);
                        return;
                    }
                }
            }
            if (cuddleEmpty && !lcurly.getParent().hasCommentsAfter()) {
                this.printBracesCuddled(closeBraceType, lcurly, true, out);
                return;
            }
        }
        switch (out.last) {
            case 115: 
            case 132: {
                break;
            }
            default: {
                if (node.getFirstChild() != null) break;
                if (insertEmptyStatement) {
                    this.printBracesEmptyStatement(lcurly, leftBraceNewline, forceNewlineBefore, freestanding, closeBraceType, out);
                } else if (cuddleEmpty && !lcurly.getParent().hasCommentsAfter()) {
                    this.printBracesCuddled(closeBraceType, lcurly, false, out);
                } else {
                    int offset = out.printLeftBrace();
                    this.trackPosition(lcurly, out.line - 1, offset, out);
                    if (out.state.newlineBeforeLeftBrace) {
                        out.state.newlineBeforeLeftBrace = false;
                    }
                    out.printRightBrace(8, !treatDifferent, true);
                    JavaNode rcurly = (JavaNode)lcurly.getFirstChild();
                    this.trackPosition(rcurly, out.line - 1, offset + 1, out);
                    out.last = closeBraceType;
                }
                return;
            }
        }
        boolean brace = true;
        boolean indent = false;
        boolean forceNewLineAfter = true;
        int wrapLineCount = Integer.MAX_VALUE;
        boolean removeBlockBraces = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_REMOVE_BLOCK, true);
        if (freestanding) {
            if (removeBlockBraces && this.canRemoveBraces(lcurly)) {
                brace = false;
            }
            switch (lcurly.getParent().getType()) {
                case 56: {
                    forceNewLineAfter = !AbstractPrinter.settings.getBoolean(ConventionKeys.ANON_LCURLY_NO_NEW_LINE, true);
                    wrapLineCount = AbstractPrinter.settings.getInt(ConventionKeys.ANON_ALIGN_VALUES_WHEN_EXCEEDS, 0);
                    newLineAfter = false;
                }
            }
            indent = false;
        } else {
            switch (out.last) {
                case 121: {
                    if (!AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_REMOVE_IF_ELSE, false) || this.isBraceNecessary(node)) break;
                    brace = false;
                    indent = true;
                    out.printNewline();
                    break;
                }
                case 131: {
                    if (!AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_REMOVE_FOR, false) || this.isBraceNecessary(node)) break;
                    brace = false;
                    indent = true;
                    out.printNewline();
                    break;
                }
                case 123: {
                    if (!AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_REMOVE_WHILE, false) || this.isBraceNecessary(node)) break;
                    brace = false;
                    indent = true;
                    out.printNewline();
                    break;
                }
                case 124: {
                    if (!AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_REMOVE_DO_WHILE, false) || this.isBraceNecessary(node)) break;
                    brace = false;
                    indent = true;
                    out.printNewline();
                    break;
                }
                case 113: {
                    newLineAfter = false;
                    forceNewLineAfter = !AbstractPrinter.settings.getBoolean(ConventionKeys.ENUM_LCURLY_NO_NEW_LINE, true);
                    wrapLineCount = AbstractPrinter.settings.getInt(ConventionKeys.ENUM_ALIGN_VALUES_WHEN_EXCEEDS, 0);
                    indent = true;
                    break;
                }
                case 107: {
                    forceNewLineAfter = !AbstractPrinter.settings.getBoolean(ConventionKeys.ANON_DEF_LCURLY_NO_NEW_LINE, false);
                    wrapLineCount = AbstractPrinter.settings.getInt(ConventionKeys.ANON_DEF_ALIGN_VALUES_WHEN_EXCEEDS, 0);
                    newLineAfter = false;
                    indent = true;
                    break;
                }
                case 115: 
                case 132: {
                    if (!this.isBraceNecessary(node)) {
                        brace = false;
                        indent = true;
                    }
                    leftBraceNewline = false;
                    break;
                }
                default: {
                    switch (lcurly.getParent().getType()) {
                        case 56: {
                            forceNewLineAfter = !AbstractPrinter.settings.getBoolean(ConventionKeys.ANON_LCURLY_NO_NEW_LINE, true);
                            wrapLineCount = AbstractPrinter.settings.getInt(ConventionKeys.ANON_ALIGN_VALUES_WHEN_EXCEEDS, 0);
                            newLineAfter = false;
                            indent = true;
                        }
                    }
                }
            }
        }
        if (brace) {
            boolean indentBrace = !freestanding && !forceNewlineBefore;
            this.printLeftBrace(lcurly, leftBraceNewline, forceNewlineBefore, forceNewLineAfter, freestanding, indentBrace, out);
        } else if (indent) {
            out.indent();
            out.last = 7;
        }
        JavaNode rcurly = null;
        int enumCounter = 1;
        int currentLine = out.line;
        AST child = node.getFirstChild();
        block30: while (child != null) {
            switch (child.getType()) {
                case 8: {
                    rcurly = (JavaNode)child;
                    break block30;
                }
                case 85: {
                    out.nextNewline = newLineAfter;
                    PrinterFactory.create(child, out).print(child, out);
                    if (!newLineAfter) break;
                    out.printNewline();
                    out.nextNewline = false;
                    break;
                }
                default: {
                    if (wrapLineCount != Integer.MAX_VALUE) {
                        if (++enumCounter > wrapLineCount) {
                            enumCounter = 1;
                            newLineAfter = true;
                        } else {
                            newLineAfter = false;
                        }
                    }
                    currentLine = out.line;
                    out.nextNewline = newLineAfter;
                    PrinterFactory.create(child, out).print(child, out);
                    if (currentLine == out.line) {
                        AST nextNode = child.getNextSibling();
                        if (newLineAfter && nextNode != null && nextNode.getType() != 85) {
                            newLineAfter = false;
                            out.printNewline();
                        }
                    } else {
                        newLineAfter = false;
                        enumCounter = 0;
                    }
                    out.nextNewline = false;
                }
            }
            child = child.getNextSibling();
        }
        if (brace) {
            this.printCommentsBefore(rcurly, out);
            boolean rightBraceNewline = this.isCloseBraceNewline(lcurly, closeBraceType, freestanding);
            boolean addCustomComment = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_ADD_COMMENT, false);
            int offset = out.printRightBrace(closeBraceType, !treatDifferent && !freestanding, rightBraceNewline && !rcurly.hasCommentsAfter() && !addCustomComment);
            this.trackPosition(rcurly, rightBraceNewline ? out.line - 1 : out.line, offset, out);
            if (addCustomComment) {
                this.prepareComment(lcurly, rcurly, out);
            }
            this.printCommentsAfter(rcurly, false, false, out);
        } else if (indent) {
            out.unindent();
        }
    }

    private boolean isBraceNecessary(AST node) {
        switch (node.getType()) {
            case 11: {
                return true;
            }
        }
        int count = 0;
        AST child = node.getFirstChild();
        while (child != null) {
            block3 : switch (count++) {
                case 0: {
                    switch (child.getType()) {
                        case 15: {
                            return true;
                        }
                        case 33: 
                        case 43: 
                        case 125: 
                        case 126: 
                        case 127: 
                        case 129: {
                            break block3;
                        }
                        case 7: {
                            JavaNode lcurly = (JavaNode)child;
                            if (!lcurly.hasCommentsBefore() && !lcurly.hasCommentsAfter()) break block3;
                            return true;
                        }
                    }
                    return true;
                }
                case 1: {
                    switch (child.getType()) {
                        case 8: {
                            JavaNode rcurly = (JavaNode)child;
                            return rcurly.hasCommentsBefore() || rcurly.hasCommentsAfter();
                        }
                    }
                    break;
                }
                case 2: {
                    return true;
                }
            }
            child = child.getNextSibling();
        }
        return false;
    }

    private boolean isCloseBraceNewline(JavaNode node, int type, boolean freestanding) {
        boolean rightBraceNewline = true;
        if (type == 11) {
            switch (node.getParent().getType()) {
                case 168: {
                    return false;
                }
                case 56: {
                    return false;
                }
            }
            return true;
        }
        if (!freestanding) {
            JavaNode next = (JavaNode)node.getNextSibling();
            if (next != null) {
                switch (next.getType()) {
                    case 122: 
                    case 134: 
                    case 135: {
                        rightBraceNewline = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false);
                        break;
                    }
                    case 123: {
                        switch (next.getParent().getType()) {
                            case 124: {
                                rightBraceNewline = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false);
                            }
                        }
                    }
                }
            } else {
                JavaNode parent = node.getParent();
                switch (parent.getType()) {
                    case 135: {
                        AST n = parent.getNextSibling();
                        if (n == null) break;
                        switch (n.getType()) {
                            case 134: 
                            case 135: {
                                rightBraceNewline = AbstractPrinter.settings.getBoolean(ConventionKeys.BRACE_NEWLINE_RIGHT, false);
                            }
                        }
                    }
                }
            }
        }
        return rightBraceNewline;
    }

    private boolean canRemoveBraces(JavaNode lcurly) {
        switch (lcurly.getParent().getType()) {
            case 16: 
            case 56: {
                return false;
            }
        }
        if (lcurly.hasCommentsBefore()) {
            return false;
        }
        AST child = lcurly.getFirstChild();
        while (child != null) {
            switch (child.getType()) {
                case 15: {
                    return false;
                }
            }
            child = child.getNextSibling();
        }
        return true;
    }

    private void printBracesCuddled(int type, JavaNode lcurly, boolean newlineAfter, NodeWriter out) throws IOException {
        JavaNode rcurly;
        out.print(out.getString(AbstractPrinter.settings.getInt(ConventionKeys.INDENT_SIZE_BRACE_CUDDLED, 1)), 175);
        out.print("{}", type);
        if (out.state.newlineBeforeLeftBrace) {
            out.state.newlineBeforeLeftBrace = false;
        }
        if (!this.printCommentsAfter(rcurly = (JavaNode)lcurly.getFirstChild(), false, newlineAfter, out) && newlineAfter) {
            out.printNewline();
        }
    }

    private void printBracesEmptyStatement(JavaNode lcurly, boolean leftBraceNewline, boolean forceNewlineBefore, boolean freestanding, int type, NodeWriter out) throws IOException {
        JavaNode rcurly = (JavaNode)lcurly.getFirstChild();
        this.printLeftBrace(lcurly, leftBraceNewline, forceNewlineBefore, false, freestanding, true, out);
        if (out.state.newlineBeforeLeftBrace) {
            out.state.newlineBeforeLeftBrace = false;
        }
        out.print(";", out.last);
        out.printNewline();
        boolean newLineAfterBrace = this.isCloseBraceNewline(lcurly, type, freestanding);
        int offset = out.printRightBrace(type, false);
        this.trackPosition(rcurly, out.line, offset, out);
        if (!this.printCommentsAfter(rcurly, false, newLineAfterBrace, out) && newLineAfterBrace) {
            out.printNewline();
        }
        out.last = type;
    }

    private void printLeftBrace(JavaNode lcurly, boolean leftBraceNewline, boolean forceNewlineBefore, boolean forceNewLineAfter, boolean freestanding, boolean indent, NodeWriter out) throws IOException {
        AST next;
        int offset;
        if (lcurly.hasCommentsBefore() || freestanding) {
            this.printCommentsBefore(lcurly, false, out);
        }
        boolean commentsAfter = lcurly.hasCommentsAfter();
        boolean bl = forceNewLineAfter = forceNewLineAfter && !commentsAfter;
        if (freestanding) {
            offset = out.printLeftBrace(false, forceNewLineAfter, false);
            this.trackPosition(lcurly, commentsAfter ? out.line : out.line - 1, offset, out);
        } else if (forceNewlineBefore) {
            offset = out.printLeftBrace(true, forceNewLineAfter, false);
            this.trackPosition(lcurly, commentsAfter ? out.line : out.line - 1, offset, out);
        } else if (out.newline) {
            offset = out.printLeftBrace(false, forceNewLineAfter, indent);
            this.trackPosition(lcurly, commentsAfter ? out.line : out.line - 1, offset, out);
        } else {
            offset = out.printLeftBrace(leftBraceNewline, forceNewLineAfter, indent);
            this.trackPosition(lcurly, commentsAfter ? out.line : out.line - 1, offset, out);
        }
        if (leftBraceNewline && commentsAfter && (next = lcurly.getFirstChild()) != null && next.getType() == 8) {
            out.printNewline();
        }
        if (out.state.newlineBeforeLeftBrace) {
            out.state.newlineBeforeLeftBrace = false;
        }
        if (commentsAfter) {
            this.printCommentsAfter(lcurly, true, true, out);
        }
    }
}

