/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.axis2.clustering.LoadBalanceEventHandler;
import org.apache.axis2.clustering.control.wka.MemberJoinedCommand;
import org.apache.axis2.clustering.tribes.LoadBalancerInterceptor;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.clustering.tribes.OperationMode;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadBalancerMode
implements OperationMode {
    private static final Log log = LogFactory.getLog(LoadBalancerMode.class);
    private byte[] loadBalancerDomain;
    private Map<String, LoadBalanceEventHandler> lbEventHandlers;
    private List<MembershipManager> membershipManagers = new ArrayList<MembershipManager>();
    private MembershipManager primaryMembershipManager;

    public LoadBalancerMode(byte[] loadBalancerDomain, Map<String, LoadBalanceEventHandler> lbEventHandlers, MembershipManager primaryMembershipManager) {
        this.loadBalancerDomain = loadBalancerDomain;
        this.lbEventHandlers = lbEventHandlers;
        this.primaryMembershipManager = primaryMembershipManager;
    }

    @Override
    public void addInterceptors(Channel channel) {
        LoadBalancerInterceptor lbInterceptor = new LoadBalancerInterceptor(this.loadBalancerDomain);
        lbInterceptor.setOptionFlag(1024);
        channel.addInterceptor((ChannelInterceptor)lbInterceptor);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Added Load Balancer Interceptor");
        }
    }

    @Override
    public void init(Channel channel) {
        Iterator<String> i$ = this.lbEventHandlers.keySet().iterator();
        while (i$.hasNext()) {
            String o;
            String domain = o = i$.next();
            final MembershipManager membershipManager = new MembershipManager();
            membershipManager.setDomain(domain.getBytes());
            membershipManager.setLoadBalanceEventHandler(this.lbEventHandlers.get(domain));
            MembershipListener membershipListener = new MembershipListener(){

                public void memberAdded(Member member) {
                    membershipManager.memberAdded(member);
                }

                public void memberDisappeared(Member member) {
                    membershipManager.memberDisappeared(member);
                }
            };
            channel.addMembershipListener(membershipListener);
            this.membershipManagers.add(membershipManager);
        }
    }

    @Override
    public List<MembershipManager> getMembershipManagers() {
        return this.membershipManagers;
    }

    @Override
    public void notifyMemberJoin(final Member member) {
        if (TribesUtil.isInDomain(member, this.loadBalancerDomain)) {
            this.primaryMembershipManager.sendMemberJoinedToAll(member);
            for (MembershipManager manager : this.membershipManagers) {
                manager.sendMemberList(member);
            }
        } else {
            Thread th = new Thread(){

                public void run() {
                    for (MembershipManager manager : LoadBalancerMode.this.membershipManagers) {
                        if (!TribesUtil.isInDomain(member, manager.getDomain())) continue;
                        manager.sendMemberJoinedToAll(member);
                        this.sendMemberJoinedToLoadBalancerGroup(manager.getRpcMembershipChannel(), member);
                        break;
                    }
                }

                private void sendMemberJoinedToLoadBalancerGroup(RpcChannel rpcChannel, Member member2) {
                    MemberJoinedCommand cmd = new MemberJoinedCommand();
                    cmd.setMember(member2);
                    try {
                        rpcChannel.send(LoadBalancerMode.this.primaryMembershipManager.getMembers(), (Serializable)((Object)cmd), 3, 8, 10000L);
                    }
                    catch (ChannelException e) {
                        String errMsg = "Could not send MEMBER_JOINED[" + TribesUtil.getName(member2) + "] to all load balancer members ";
                        log.error((Object)errMsg, (Throwable)e);
                        throw new RemoteProcessException(errMsg, (Throwable)e);
                    }
                }
            };
            th.start();
        }
    }
}

