/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMOutputFormat;
import org.codehaus.jettison.json.JSONTokener;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;

public class JSONDataSource
implements OMDataSource {
    private InputStream jsonInputStream;
    private String jsonString;
    private boolean isRead = false;
    protected String localName;

    public JSONDataSource(InputStream jsonInputStream, String localName) {
        this.jsonInputStream = jsonInputStream;
        this.localName = localName;
    }

    public void serialize(OutputStream outputStream, OMOutputFormat omOutputFormat) throws XMLStreamException {
        try {
            outputStream.write(this.getCompleteJOSNString().getBytes());
        }
        catch (IOException e) {
            throw new OMException();
        }
    }

    public void serialize(Writer writer, OMOutputFormat omOutputFormat) throws XMLStreamException {
        try {
            writer.write(this.getCompleteJOSNString());
        }
        catch (IOException e) {
            throw new OMException();
        }
    }

    public void serialize(XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        XMLStreamReader reader = this.getReader();
        xmlStreamWriter.writeStartDocument();
        block13: while (reader.hasNext()) {
            int x = reader.next();
            switch (x) {
                case 1: {
                    xmlStreamWriter.writeStartElement(reader.getPrefix(), reader.getLocalName(), reader.getNamespaceURI());
                    int namespaceCount = reader.getNamespaceCount();
                    for (int i = namespaceCount - 1; i >= 0; --i) {
                        xmlStreamWriter.writeNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i));
                    }
                    int attributeCount = reader.getAttributeCount();
                    for (int i = 0; i < attributeCount; ++i) {
                        xmlStreamWriter.writeAttribute(reader.getAttributePrefix(i), reader.getAttributeNamespace(i), reader.getAttributeLocalName(i), reader.getAttributeValue(i));
                    }
                    continue block13;
                }
                case 7: {
                    break;
                }
                case 4: {
                    xmlStreamWriter.writeCharacters(reader.getText());
                    break;
                }
                case 12: {
                    xmlStreamWriter.writeCData(reader.getText());
                    break;
                }
                case 2: {
                    xmlStreamWriter.writeEndElement();
                    break;
                }
                case 8: {
                    xmlStreamWriter.writeEndDocument();
                    break;
                }
                case 6: {
                    break;
                }
                case 5: {
                    xmlStreamWriter.writeComment(reader.getText());
                    break;
                }
                case 11: {
                    xmlStreamWriter.writeDTD(reader.getText());
                    break;
                }
                case 3: {
                    xmlStreamWriter.writeProcessingInstruction(reader.getPITarget(), reader.getPIData());
                    break;
                }
                case 9: {
                    xmlStreamWriter.writeEntityRef(reader.getLocalName());
                    break;
                }
                default: {
                    throw new OMException();
                }
            }
        }
        xmlStreamWriter.writeEndDocument();
    }

    public XMLStreamReader getReader() throws XMLStreamException {
        HashMap<String, String> XMLToJSNNamespaceMap = new HashMap<String, String>();
        XMLToJSNNamespaceMap.put("", "");
        MappedXMLInputFactory inputFactory = new MappedXMLInputFactory(XMLToJSNNamespaceMap);
        String jsonString = "{" + this.localName + ":" + this.getJSONString();
        return inputFactory.createXMLStreamReader(new JSONTokener(jsonString));
    }

    protected String getJSONString() {
        if (this.isRead) {
            return this.jsonString;
        }
        try {
            char temp = (char)this.jsonInputStream.read();
            this.jsonString = "";
            while (temp != '\uffff') {
                this.jsonString = this.jsonString + temp;
                temp = (char)this.jsonInputStream.read();
            }
        }
        catch (IOException e) {
            throw new OMException();
        }
        this.isRead = true;
        return this.jsonString;
    }

    public String getCompleteJOSNString() {
        return "{" + this.localName + ":" + this.getJSONString();
    }
}

