/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import java.lang.reflect.Method;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RequestStateManagerDelegate {
    private static final Log log = LogFactory.getLog((Class)RequestStateManagerDelegate.class);
    private static final String DELEGATE_CLASS_KEY = "com.sun.faces.util.RequestStateManager";
    private static final String PENDING_MESSAGES_KEY = "com.sun.faces.clientIdMessagesNotDisplayed";
    private static boolean detected = false;
    private static Method containsKeyMethod = null;
    private static Method getMethod = null;

    private RequestStateManagerDelegate() {
    }

    public static void clearMessages(FacesContext fc) {
        Set pendingMessageIds;
        if (!detected || fc == null) {
            return;
        }
        if (RequestStateManagerDelegate.containsKey(fc) && (pendingMessageIds = RequestStateManagerDelegate.getPendingMessageIds(fc)) != null) {
            pendingMessageIds.clear();
        }
    }

    public static void clearMessages(FacesContext fc, String clientID) {
        if (!detected || fc == null || clientID == null) {
            return;
        }
        Set pendingMessageIds = RequestStateManagerDelegate.getPendingMessageIds(fc);
        if (pendingMessageIds != null && !pendingMessageIds.isEmpty()) {
            pendingMessageIds.remove(clientID);
        }
    }

    private static boolean containsKey(FacesContext fc) {
        try {
            Object containsKeyResult = containsKeyMethod.invoke(null, fc, PENDING_MESSAGES_KEY);
            return (Boolean)containsKeyResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private static Set getPendingMessageIds(FacesContext fc) {
        try {
            Object getResult = getMethod.invoke(null, fc, PENDING_MESSAGES_KEY);
            return (Set)getResult;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        try {
            Class<?> rsmClass = Class.forName(DELEGATE_CLASS_KEY);
            containsKeyMethod = rsmClass.getMethod("containsKey", FacesContext.class, String.class);
            getMethod = rsmClass.getMethod("get", FacesContext.class, String.class);
            detected = true;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"com.sun.faces.util.RequestStateManager was not detected");
            }
            detected = false;
        }
    }
}

