/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.util;

import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThreadLocalUtility {
    private static final Log log = LogFactory.getLog((Class)ThreadLocalUtility.class);
    public static final int EXITING_SERVLET_CORE = 0;
    public static final int EXITING_SERVER_PUSH = 1;
    public static final int EXITING_SESSION_MONITOR = 2;
    private static final int size = 3;
    private static int[] Counts = new int[3];
    private static String[] Descriptions = new String[]{"Exiting servlet execution", "Exiting server push", "Exiting session expiry monitor"};
    private static boolean threadLocalFailed;
    private static String firstFailure;
    private static boolean testingEnabled;

    public static void checkThreadLocals(int location) {
        if (!testingEnabled) {
            return;
        }
        int n = location;
        Counts[n] = Counts[n] + 1;
        if (!BridgeFacesContext.isThreadLocalNull()) {
            if (!threadLocalFailed) {
                firstFailure = "BridgeFacesState failure, location: " + Descriptions[location];
            }
            threadLocalFailed = true;
            log.error((Object)("BridgeFacesContext ThreadLocal is NON-NULL: " + Descriptions[location]));
        } else {
            log.debug((Object)("BridgeFacesContext ThreadLocal is OK: " + Descriptions[location]));
        }
        if (!PersistentFacesState.isThreadLocalNull()) {
            if (!threadLocalFailed) {
                firstFailure = "PersistentFacesState failure, location: " + Descriptions[location];
            }
            threadLocalFailed = true;
            log.error((Object)("PersistentFacesState ThreadLocal is NON-NULL: " + Descriptions[location]));
        } else {
            log.debug((Object)("PersistentFacesState ThreadLocal is OK: " + Descriptions[location]));
        }
    }

    public static boolean isFailed() {
        return threadLocalFailed;
    }

    public static String getFailureLocation() {
        return firstFailure;
    }

    public static int[] getTestCounts() {
        return Counts;
    }

    public static void setPerformTesting(boolean testingEnabled) {
        ThreadLocalUtility.testingEnabled = testingEnabled;
    }
}

