/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.async.render;

import com.icesoft.faces.async.render.AsyncRenderer;
import com.icesoft.faces.async.render.RenderManager;
import com.icesoft.faces.async.render.Renderable;
import com.icesoft.faces.context.View;
import com.icesoft.faces.webapp.http.servlet.MainSessionBoundServlet;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.faces.webapp.xmlhttp.PersistentFacesState;
import com.icesoft.faces.webapp.xmlhttp.RenderingException;
import com.icesoft.util.StaticTimerUtility;
import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupAsyncRenderer
implements AsyncRenderer {
    private static final Log LOG = LogFactory.getLog((Class)GroupAsyncRenderer.class);
    protected final Set group = new CopyOnWriteArraySet();
    protected boolean broadcasted = false;
    protected String name;
    protected boolean stopRequested = false;
    String lastRenderInfo = "";

    public void add(Renderable renderable) throws IllegalArgumentException {
        if (renderable == null) {
            throw new IllegalArgumentException("renderable is null");
        }
        this.add((Object)renderable);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addCurrentSession() throws IllegalStateException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            if (!LOG.isWarnEnabled()) return;
            LOG.warn((Object)("Add current session cannot be done from non-JSF thread. Failed to add session to group '" + this.name + "'."));
            return;
        }
        Object session = facesContext.getExternalContext().getSession(false);
        if (session != null) {
            this.add(GroupAsyncRenderer.getSessionID(session));
            return;
        }
        LOG.warn((Object)"Unable to add current session: no current session active");
        throw new IllegalStateException("Unable to add current session: no current session active");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Set set = this.group;
        synchronized (set) {
            this.group.clear();
        }
    }

    public boolean contains(Renderable renderable) {
        return this.contains((Object)renderable);
    }

    public boolean containsCurrentSession() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext == null) {
            return false;
        }
        return this.contains(GroupAsyncRenderer.getSessionID(facesContext.getExternalContext().getSession(false)));
    }

    private static String getSessionID(Object session) {
        if (session == null) {
            return null;
        }
        try {
            Method getIdMethod = session.getClass().getMethod("getId", null);
            Object id = getIdMethod.invoke(session, null);
            return id.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void dispose() {
        this.requestStop();
        RenderManager.getInstance().removeRenderer(this);
        this.clear();
        this.name = null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isBroadcasted() {
        return this.broadcasted;
    }

    public boolean isEmpty() {
        return this.group.isEmpty();
    }

    public void remove(Renderable renderable) {
        this.remove((Object)renderable);
    }

    public void removeCurrentSession() {
        LOG.info((Object)"GroupAsyncRenderer.removeCurrentSession()");
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            Object session = facesContext.getExternalContext().getSession(false);
            if (session != null) {
                this.remove(GroupAsyncRenderer.getSessionID(session));
            } else {
                LOG.warn((Object)"Unable to remove current session: no current session active");
            }
        }
    }

    public String getLastRenderInfo() {
        return this.lastRenderInfo;
    }

    public void requestRender() {
        this.requestRender(true);
    }

    public void requestRender(boolean allowBroadcasting) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.name + " preparing to render " + this.group.size()));
        }
        this.lastRenderInfo = "groupSize=" + this.group.size() + " startTime=" + System.currentTimeMillis();
        if (allowBroadcasting && this.isBroadcasted()) {
            RenderManager.getInstance().requestRender(this);
        }
        this.stopRequested = false;
        if (StaticTimerUtility.Log.isTraceEnabled()) {
            StaticTimerUtility.newJob(this.group.size());
            StaticTimerUtility.startJobTmer();
        }
        Iterator i = this.group.iterator();
        while (!this.stopRequested && i.hasNext()) {
            WeakReference reference = (WeakReference)i.next();
            Object object = reference.get();
            if (object == null) {
                this.group.remove(reference);
                continue;
            }
            if (object instanceof Renderable) {
                this.requestRender((Renderable)object);
                continue;
            }
            if (!(object instanceof String)) continue;
            String sessionId = (String)object;
            try {
                this.requestRender(sessionId);
            }
            catch (Exception exception) {
                this.remove(sessionId);
            }
        }
    }

    public void requestStop() {
        this.stopRequested = true;
    }

    public void setBroadcasted(boolean broadcasted) {
        this.broadcasted = broadcasted;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRenderManager(RenderManager renderManager) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Object object) {
        Set set = this.group;
        synchronized (set) {
            if (!this.contains(object)) {
                if (this.group.add(new WeakReference<Object>(object))) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(this.name + " added " + object));
                    }
                } else if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)(this.name + " already contains " + object));
                }
            }
        }
    }

    private boolean contains(Object object) {
        Iterator i = this.group.iterator();
        while (i.hasNext()) {
            if (object != ((WeakReference)i.next()).get()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Object object) {
        Set set = this.group;
        synchronized (set) {
            Iterator i = this.group.iterator();
            while (i.hasNext()) {
                WeakReference reference = (WeakReference)i.next();
                if (object != reference.get()) continue;
                this.group.remove(reference);
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(this.name + " removing " + object));
                }
                return;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)(this.name + " does not contain " + object));
            }
        }
    }

    private void requestRender(String sessionId) {
        PersistentFacesState suppressedViewState = FacesContext.getCurrentInstance() != null ? PersistentFacesState.getInstance() : null;
        PseudoServlet serv = SessionDispatcher.getSingletonSessionServer(sessionId, RenderManager.getInstance().getServletContext());
        if (serv == null) {
            this.group.remove(sessionId);
            return;
        }
        Iterator i = ((MainSessionBoundServlet)serv).getViews().values().iterator();
        while (i.hasNext()) {
            final PersistentFacesState viewState = ((View)i.next()).getPersistentFacesState();
            if (viewState == suppressedViewState) continue;
            this.requestRender(new Renderable(){

                public PersistentFacesState getState() {
                    return viewState;
                }

                public void renderingException(RenderingException renderingException) {
                }
            });
        }
    }

    private void requestRender(Renderable renderable) {
        RenderManager.getInstance().requestRender(renderable);
    }
}

