/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Version {
    private final String _name;
    private final boolean _beta;
    private final byte _major;
    private final byte _micro;
    private final byte _minor;

    public Version(String name, int major, int minor) {
        this(name, major, minor, 0);
    }

    public Version(String name, int major, int minor, int micro) {
        this(name, major, minor, micro, false);
    }

    public Version(String name, int major, int minor, int micro, boolean beta) {
        this._name = name;
        this._major = (byte)major;
        this._minor = (byte)minor;
        this._micro = (byte)micro;
        this._beta = beta;
    }

    public boolean isBeta() {
        return this._beta;
    }

    public byte getMajorNumber() {
        return this._major;
    }

    public byte getMicroNumber() {
        return this._micro;
    }

    public byte getMinorNumber() {
        return this._minor;
    }

    public String getName() {
        return this._name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Version) {
            Version other = (Version)o;
            return this._minor == other._minor && this._major == other._major && this._beta == other._beta && this._micro == other._micro && this._name.equals(other._name);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = result * 37 + this._major;
        result = result * 37 + this._minor;
        result = result * 37 + this._micro;
        result = result * 37 + (this._beta ? 1 : 2);
        return this._name.hashCode() + result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(10);
        buf.append(this._major);
        buf.append('.');
        buf.append(this._minor);
        if (this._beta) {
            buf.append('b');
        } else {
            buf.append('.');
        }
        buf.append(this._micro);
        return buf.toString();
    }

    public static Version valueOf(String version) {
        Pattern regexp = Pattern.compile("(\\d).(\\d)(?:([.b])(\\d+))?");
        Matcher matcher = regexp.matcher(version);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int micro = 0;
            boolean beta = false;
            if (matcher.groupCount() == 5) {
                beta = matcher.group(3).indexOf(98) > -1;
                micro = Integer.parseInt(matcher.group(4));
            }
            return new Version(null, major, minor, micro, beta);
        }
        throw new IllegalArgumentException("invalid version information -- " + version);
    }
}

