/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.switchuser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationCredentialsNotFoundException;
import org.springframework.security.AuthenticationException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.SpringSecurityMessageSource;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.event.authentication.AuthenticationSwitchUserEvent;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.ui.AuthenticationDetailsSource;
import org.springframework.security.ui.FilterChainOrder;
import org.springframework.security.ui.SpringSecurityFilter;
import org.springframework.security.ui.WebAuthenticationDetailsSource;
import org.springframework.security.ui.switchuser.SwitchUserAuthorityChanger;
import org.springframework.security.ui.switchuser.SwitchUserGrantedAuthority;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsChecker;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.checker.AccountStatusUserDetailsChecker;
import org.springframework.security.util.RedirectUtils;
import org.springframework.util.Assert;

public class SwitchUserProcessingFilter
extends SpringSecurityFilter
implements InitializingBean,
ApplicationEventPublisherAware,
MessageSourceAware {
    public static final String SPRING_SECURITY_SWITCH_USERNAME_KEY = "j_username";
    public static final String ROLE_PREVIOUS_ADMINISTRATOR = "ROLE_PREVIOUS_ADMINISTRATOR";
    private ApplicationEventPublisher eventPublisher;
    private AuthenticationDetailsSource authenticationDetailsSource = new WebAuthenticationDetailsSource();
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private String exitUserUrl = "/j_spring_security_exit_user";
    private String switchUserUrl = "/j_spring_security_switch_user";
    private String targetUrl;
    private String switchFailureUrl;
    private SwitchUserAuthorityChanger switchUserAuthorityChanger;
    private UserDetailsService userDetailsService;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    private boolean useRelativeContext;

    public void afterPropertiesSet() throws Exception {
        Assert.hasLength((String)this.switchUserUrl, (String)"switchUserUrl must be specified");
        Assert.hasLength((String)this.exitUserUrl, (String)"exitUserUrl must be specified");
        Assert.hasLength((String)this.targetUrl, (String)"targetUrl must be specified");
        Assert.notNull((Object)this.userDetailsService, (String)"authenticationDao must be specified");
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
    }

    protected Authentication attemptExitUser(HttpServletRequest request) throws AuthenticationCredentialsNotFoundException {
        Authentication current = SecurityContextHolder.getContext().getAuthentication();
        if (null == current) {
            throw new AuthenticationCredentialsNotFoundException(this.messages.getMessage("SwitchUserProcessingFilter.noCurrentUser", "No current user associated with this request"));
        }
        Authentication original = this.getSourceAuthentication(current);
        if (original == null) {
            this.logger.error((Object)"Could not find original user Authentication object!");
            throw new AuthenticationCredentialsNotFoundException(this.messages.getMessage("SwitchUserProcessingFilter.noOriginalAuthentication", "Could not find original Authentication object"));
        }
        UserDetails originalUser = null;
        Object obj = original.getPrincipal();
        if (obj != null && obj instanceof UserDetails) {
            originalUser = (UserDetails)obj;
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new AuthenticationSwitchUserEvent(current, originalUser));
        }
        return original;
    }

    protected Authentication attemptSwitchUser(HttpServletRequest request) throws AuthenticationException {
        UsernamePasswordAuthenticationToken targetUserRequest = null;
        String username = request.getParameter(SPRING_SECURITY_SWITCH_USERNAME_KEY);
        if (username == null) {
            username = "";
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Attempt to switch to user [" + username + "]"));
        }
        UserDetails targetUser = this.userDetailsService.loadUserByUsername(username);
        this.userDetailsChecker.check(targetUser);
        targetUserRequest = this.createSwitchUserToken(request, targetUser);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Switch User Token [" + targetUserRequest + "]"));
        }
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent((ApplicationEvent)new AuthenticationSwitchUserEvent(SecurityContextHolder.getContext().getAuthentication(), targetUser));
        }
        return targetUserRequest;
    }

    private UsernamePasswordAuthenticationToken createSwitchUserToken(HttpServletRequest request, UserDetails targetUser) {
        Authentication currentAuth = SecurityContextHolder.getContext().getAuthentication();
        SwitchUserGrantedAuthority switchAuthority = new SwitchUserGrantedAuthority(ROLE_PREVIOUS_ADMINISTRATOR, currentAuth);
        List orig = Arrays.asList(targetUser.getAuthorities());
        if (this.switchUserAuthorityChanger != null) {
            orig = this.switchUserAuthorityChanger.modifyGrantedAuthorities(targetUser, currentAuth, orig);
        }
        ArrayList<GrantedAuthority> newAuths = new ArrayList<GrantedAuthority>(orig);
        newAuths.add(switchAuthority);
        GrantedAuthority[] authorities = newAuths.toArray(new GrantedAuthority[newAuths.size()]);
        UsernamePasswordAuthenticationToken targetUserRequest = new UsernamePasswordAuthenticationToken(targetUser, targetUser.getPassword(), authorities);
        targetUserRequest.setDetails(this.authenticationDetailsSource.buildDetails(request));
        return targetUserRequest;
    }

    public void doFilterHttp(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.requiresSwitchUser(request)) {
            try {
                Authentication targetUser = this.attemptSwitchUser(request);
                SecurityContextHolder.getContext().setAuthentication(targetUser);
                this.sendRedirect(request, response, this.targetUrl);
            }
            catch (AuthenticationException e) {
                this.redirectToFailureUrl(request, response, e);
            }
            return;
        }
        if (this.requiresExitUser(request)) {
            Authentication originalUser = this.attemptExitUser(request);
            SecurityContextHolder.getContext().setAuthentication(originalUser);
            this.sendRedirect(request, response, this.targetUrl);
            return;
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private void redirectToFailureUrl(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException {
        this.logger.debug((Object)"Switch User failed", (Throwable)((Object)failed));
        if (this.switchFailureUrl != null) {
            this.switchFailureUrl = request.getContextPath() + this.switchFailureUrl;
            response.sendRedirect(response.encodeRedirectURL(this.switchFailureUrl));
        } else {
            response.getWriter().print("Switch user failed: " + failed.getMessage());
            response.flushBuffer();
        }
    }

    protected void sendRedirect(HttpServletRequest request, HttpServletResponse response, String url) throws IOException {
        RedirectUtils.sendRedirect(request, response, url, this.useRelativeContext);
    }

    private Authentication getSourceAuthentication(Authentication current) {
        Authentication original = null;
        GrantedAuthority[] authorities = current.getAuthorities();
        for (int i = 0; i < authorities.length; ++i) {
            if (!(authorities[i] instanceof SwitchUserGrantedAuthority)) continue;
            original = ((SwitchUserGrantedAuthority)authorities[i]).getSource();
            this.logger.debug((Object)("Found original switch user granted authority [" + original + "]"));
        }
        return original;
    }

    protected boolean requiresExitUser(HttpServletRequest request) {
        String uri = SwitchUserProcessingFilter.stripUri(request);
        return uri.endsWith(request.getContextPath() + this.exitUserUrl);
    }

    protected boolean requiresSwitchUser(HttpServletRequest request) {
        String uri = SwitchUserProcessingFilter.stripUri(request);
        return uri.endsWith(request.getContextPath() + this.switchUserUrl);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher eventPublisher) throws BeansException {
        this.eventPublisher = eventPublisher;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource authenticationDetailsSource) {
        Assert.notNull((Object)authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setExitUserUrl(String exitUserUrl) {
        this.exitUserUrl = exitUserUrl;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setSwitchUserUrl(String switchUserUrl) {
        this.switchUserUrl = switchUserUrl;
    }

    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setUseRelativeContext(boolean useRelativeContext) {
        this.useRelativeContext = useRelativeContext;
    }

    public void setSwitchFailureUrl(String switchFailureUrl) {
        this.switchFailureUrl = switchFailureUrl;
    }

    private static String stripUri(HttpServletRequest request) {
        String uri = request.getRequestURI();
        int idx = uri.indexOf(59);
        if (idx > 0) {
            uri = uri.substring(0, idx);
        }
        return uri;
    }

    public void setSwitchUserAuthorityChanger(SwitchUserAuthorityChanger switchUserAuthorityChanger) {
        this.switchUserAuthorityChanger = switchUserAuthorityChanger;
    }

    public int getOrder() {
        return FilterChainOrder.SWITCH_USER_FILTER;
    }
}

