/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.env;

import com.icesoft.faces.env.Authorization;
import java.security.Principal;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.context.SecurityContext;

public class SpringAuthWrapper
implements Authorization {
    private static final Log Log = LogFactory.getLog((Class)SpringAuthWrapper.class);
    private final Authentication authentication;

    public SpringAuthWrapper(Principal principal) {
        this.authentication = (Authentication)principal;
    }

    public boolean isUserInRole(String role) {
        if (null == this.authentication) {
            return false;
        }
        Log.trace((Object)("isUserInRole ROLE: " + role));
        GrantedAuthority[] authorities = this.authentication.getAuthorities();
        if (this.authentication.getPrincipal() == null || authorities == null) {
            return false;
        }
        for (int i = 0; i < authorities.length; ++i) {
            if (!role.equals(authorities[i].getAuthority())) continue;
            return true;
        }
        return false;
    }

    public static Authorization getVerifier(Principal principal, Map sessionMap) {
        if (principal instanceof Authentication) {
            return new SpringAuthWrapper(principal);
        }
        SecurityContext sc = (SecurityContext)sessionMap.get("SPRING_SECURITY_CONTEXT");
        return new SpringAuthWrapper((Principal)(sc == null ? null : sc.getAuthentication()));
    }
}

