/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class OutputLinkRenderer
extends DomBasicRenderer {
    private static final String[] passThruAttributes = new String[]{"accesskey", "charset", "coords", "dir", "hreflang", "lang", "onblur", "onclick", "ondblclick", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "rel", "rev", "shape", "style", "tabindex", "target", "title", "type"};
    String clientId;

    public boolean getRendersChildren() {
        return false;
    }

    protected Object getValue(UIComponent uiComponent) {
        return ((UIOutput)uiComponent).getValue();
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String styleClass;
        if (facesContext == null || uiComponent == null) {
            throw new NullPointerException("facesContext or uiComponent is null");
        }
        UIOutput output = (UIOutput)uiComponent;
        String linkVal = this.getValue(facesContext, uiComponent);
        if (!output.isRendered()) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        if (writer == null) {
            throw new NullPointerException("ResponseWriter is null");
        }
        if (!this.checkDisabled(uiComponent)) {
            writer.startElement("a", uiComponent);
        } else {
            writer.startElement("span", uiComponent);
        }
        writer.writeAttribute("id", (Object)uiComponent.getClientId(facesContext), "id");
        if (null == linkVal || 0 == linkVal.length()) {
            linkVal = "";
        }
        this.clientId = output.getClientId(facesContext);
        linkVal = this.appendParameters(facesContext, uiComponent, linkVal);
        if (!this.checkDisabled(uiComponent)) {
            writer.writeURIAttribute("href", (Object)facesContext.getExternalContext().encodeResourceURL(linkVal), "href");
        }
        PassThruAttributeWriter.renderHtmlAttributes(writer, uiComponent, passThruAttributes);
        Boolean visibleAttribute = (Boolean)uiComponent.getAttributes().get("visible");
        boolean isVisible = visibleAttribute == null ? true : visibleAttribute;
        String style = (String)uiComponent.getAttributes().get("style");
        if (!isVisible) {
            if (style == null) {
                style = "";
            } else if (style.trim().length() != 0 && !style.trim().endsWith(";")) {
                style = style + ";";
            }
            style = style + "display:none;";
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if ((styleClass = (String)output.getAttributes().get("styleClass")) != null) {
            writer.writeAttribute("class", (Object)styleClass, "styleClass");
        }
        writer.flush();
    }

    protected boolean checkDisabled(UIComponent uiComponent) {
        boolean disabled = false;
        try {
            disabled = Boolean.valueOf(String.valueOf(uiComponent.getAttributes().get("disabled")));
            return disabled;
        }
        catch (Exception exception) {
            return disabled;
        }
    }

    private String appendParameters(FacesContext facesContext, UIComponent uiComponent, String hrefAttribute) {
        boolean parametersExist;
        StringBuffer hrefBuffer = new StringBuffer(hrefAttribute);
        Map parameters = OutputLinkRenderer.getParameterMap(uiComponent);
        int numberOfParameters = parameters.size();
        boolean bl = parametersExist = numberOfParameters > 0;
        if (parametersExist) {
            hrefBuffer.append("?");
            Iterator parameterKeys = parameters.keySet().iterator();
            while (parameterKeys.hasNext()) {
                String nextKey = (String)parameterKeys.next();
                Object nextValue = parameters.get(nextKey);
                hrefBuffer.append(nextKey);
                hrefBuffer.append("=");
                hrefBuffer.append(nextValue == null ? null : nextValue.toString());
                if (!parameterKeys.hasNext()) continue;
                hrefBuffer.append("&");
            }
        }
        return hrefBuffer.toString();
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        if (facesContext == null || uiComponent == null) {
            throw new NullPointerException("facesContext or uiComponent is null");
        }
        UIOutput output = (UIOutput)uiComponent;
        if (!output.isRendered()) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        if (writer == null) {
            throw new NullPointerException("ResponseWriter is null");
        }
        writer.endElement("a");
    }
}

