/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.http.servlet;

import com.icesoft.faces.async.render.RenderManager;
import com.icesoft.faces.env.Authorization;
import com.icesoft.faces.util.event.servlet.ContextEventRepeater;
import com.icesoft.faces.webapp.http.common.Configuration;
import com.icesoft.faces.webapp.http.common.FileLocator;
import com.icesoft.faces.webapp.http.common.MimeTypeMatcher;
import com.icesoft.faces.webapp.http.common.standard.NotFoundHandler;
import com.icesoft.faces.webapp.http.common.standard.ResponseHandlerServer;
import com.icesoft.faces.webapp.http.core.DisposeBeans;
import com.icesoft.faces.webapp.http.core.ResourceServer;
import com.icesoft.faces.webapp.http.servlet.BasicAdaptingServlet;
import com.icesoft.faces.webapp.http.servlet.CoreMessageService;
import com.icesoft.faces.webapp.http.servlet.MainSessionBoundServlet;
import com.icesoft.faces.webapp.http.servlet.PathDispatcher;
import com.icesoft.faces.webapp.http.servlet.PseudoServlet;
import com.icesoft.faces.webapp.http.servlet.ServletContextConfiguration;
import com.icesoft.faces.webapp.http.servlet.SessionDispatcher;
import com.icesoft.faces.webapp.http.servlet.SessionVerifier;
import com.icesoft.net.messaging.MessageServiceAdapter;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.net.messaging.http.HttpAdapter;
import com.icesoft.net.messaging.jms.JMSAdapter;
import com.icesoft.util.IdGenerator;
import com.icesoft.util.MonitorRunner;
import com.icesoft.util.SeamUtilities;
import com.icesoft.util.ServerUtility;
import edu.emory.mathcs.backport.java.util.concurrent.ScheduledThreadPoolExecutor;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MainServlet
extends HttpServlet {
    private static final Log LOG = LogFactory.getLog((Class)MainServlet.class);
    private static final CurrentContextPath currentContextPath = new CurrentContextPath();
    private static final PseudoServlet NotFound = new BasicAdaptingServlet(new ResponseHandlerServer(new NotFoundHandler("")));
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(10);
    private PathDispatcher dispatcher = new PathDispatcher();
    private ServletContext context;
    private MonitorRunner monitorRunner;
    private CoreMessageService coreMessageService;
    private String localAddress;
    private int localPort;
    private String blockingRequestHandlerContext;
    private boolean detectionDone = false;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.context = servletConfig.getServletContext();
        try {
            final ServletContextConfiguration configuration = new ServletContextConfiguration("com.icesoft.faces", this.context);
            final IdGenerator idGenerator = new IdGenerator(this.context.getResource("/WEB-INF/web.xml").getPath());
            final MimeTypeMatcher mimeTypeMatcher = new MimeTypeMatcher(){

                public String mimeTypeFor(String extension) {
                    return MainServlet.this.context.getMimeType(extension);
                }
            };
            FileLocator localFileLocator = new FileLocator(){

                public File locate(String path) {
                    URI contextURI = URI.create(currentContextPath.lookup());
                    URI pathURI = URI.create(path);
                    String result = contextURI.relativize(pathURI).getPath();
                    String fileLocation = MainServlet.this.context.getRealPath(result);
                    return new File(fileLocation);
                }
            };
            this.monitorRunner = new MonitorRunner(configuration.getAttributeAsLong("monitorRunnerInterval", 10000L));
            RenderManager.setServletConfig(servletConfig);
            BasicAdaptingServlet resourceServer = new BasicAdaptingServlet(new ResourceServer(configuration, mimeTypeMatcher, localFileLocator));
            SessionDispatcher sessionDispatcher = new SessionDispatcher(this.context){

                protected PseudoServlet newServer(HttpSession session, SessionDispatcher.Monitor sessionMonitor, Authorization authorization) {
                    return new MainSessionBoundServlet(session, sessionMonitor, idGenerator, mimeTypeMatcher, MainServlet.this.monitorRunner, configuration, MainServlet.this.getCoreMessageService(configuration), MainServlet.this.blockingRequestHandlerContext, authorization);
                }
            };
            if (SeamUtilities.isSpringEnvironment()) {
                this.dispatcher.dispatchOn("/spring/resources/", resourceServer);
            }
            this.dispatcher.dispatchOn(".*(block\\/resource\\/)", new SessionVerifier(sessionDispatcher, false));
            if (!configuration.getAttributeAsBoolean("synchronousUpdate", false)) {
                this.dispatcher.dispatchOn(".*(block\\/message)", new PseudoServlet(){

                    public void service(HttpServletRequest request, HttpServletResponse response) throws Exception {
                        if (MainServlet.this.coreMessageService != null && MainServlet.this.coreMessageService.getMessageServiceClient().getMessageServiceAdapter() instanceof HttpAdapter) {
                            ((HttpAdapter)MainServlet.this.coreMessageService.getMessageServiceClient().getMessageServiceAdapter()).getHttpMessagingDispatcher().service(request, response);
                        } else {
                            NotFound.service(request, response);
                        }
                    }

                    public void shutdown() {
                    }
                });
            }
            this.dispatcher.dispatchOn(".*(block\\/)", new SessionVerifier(sessionDispatcher, true));
            this.dispatcher.dispatchOn(".*(\\/$|\\.iface$|\\.jsf|\\.faces$|\\.jsp$|\\.jspx$|\\.html$|\\.xhtml$|\\.seam$|uploadHtml$|/spring/)", sessionDispatcher);
            this.dispatcher.dispatchOn(".*", resourceServer);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block16: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Servicing Request-URI: [" + request.getRequestURI() + "]"));
            }
            if (this.localAddress == null) {
                this.localAddress = ServerUtility.getLocalAddr(request, this.context);
                this.localPort = ServerUtility.getLocalPort(request, this.context);
            }
            try {
                currentContextPath.attach(request.getContextPath());
                this.dispatcher.service(request, response);
            }
            catch (SocketException e) {
                if ("Broken pipe".equals(e.getMessage())) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"Connection broken by client.", (Throwable)e);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Connection broken by client: " + e.getMessage()));
                    }
                    break block16;
                }
                throw new ServletException((Throwable)e);
            }
            catch (RuntimeException e) {
                if (e.getMessage() != null) {
                    throw e;
                }
                String errorClassname = e.getClass().getName();
                if (errorClassname.startsWith("org.mortbay.jetty")) {
                    throw e;
                }
                throw new RuntimeException("wrapped Exception: " + errorClassname, e);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            finally {
                currentContextPath.detach();
            }
        }
    }

    public void destroy() {
        this.monitorRunner.stop();
        DisposeBeans.in(this.context);
        this.dispatcher.shutdown();
        if (this.coreMessageService != null) {
            this.coreMessageService.stop();
            this.coreMessageService.tearDownNow();
        }
        this.scheduledThreadPoolExecutor.shutdown();
    }

    private synchronized CoreMessageService getCoreMessageService(Configuration configuration) {
        if (!this.detectionDone) {
            if (!configuration.getAttributeAsBoolean("synchronousUpdate", false)) {
                this.setUpCoreMessageService(configuration);
            }
            this.detectionDone = true;
        }
        return this.coreMessageService;
    }

    private boolean isJMSAvailable() {
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("javax.jms.TopicConnectionFactory");
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    private void setUpCoreMessageService(Configuration configuration) {
        String blockingRequestHandler = configuration.getAttribute("blockingRequestHandler", "auto-detect");
        if (blockingRequestHandler.equalsIgnoreCase("icefaces")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Blocking Request Handler: \"" + blockingRequestHandler + "\""));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Adapting to Push environment.");
            }
        } else if (blockingRequestHandler.equalsIgnoreCase("push-server") || blockingRequestHandler.equalsIgnoreCase("auto-detect")) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Blocking Request Handler: \"" + blockingRequestHandler + "\""));
            }
            String blockingRequestHandlerContext = configuration.getAttribute("blockingRequestHandlerContext", "push-server");
            this.coreMessageService = new CoreMessageService(new MessageServiceClient("Core MSC", (MessageServiceAdapter)new HttpAdapter(this.localAddress, this.localPort, this.context), currentContextPath.lookup()), this.scheduledThreadPoolExecutor, (Configuration)new ServletContextConfiguration("com.icesoft.net.messaging", this.context), blockingRequestHandlerContext);
            if (this.coreMessageService.setUpNow()) {
                this.blockingRequestHandlerContext = URI.create("/").resolve(blockingRequestHandlerContext + "/").toString();
            } else {
                this.coreMessageService = null;
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"Push Server not found - the Push Server must be deployed to support multiple asynchronous applications.");
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Adapting to Push environment.");
                }
            }
        } else {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Blocking Request Handler: \"" + blockingRequestHandler + "\""));
            }
            boolean isJMSAvailable = this.isJMSAvailable();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("JMS API Available: " + isJMSAvailable));
            }
            String blockingRequestHandlerContext = configuration.getAttribute("blockingRequestHandlerContext", "push-server");
            if (isJMSAvailable) {
                this.coreMessageService = new CoreMessageService(new MessageServiceClient("Core MSC", (MessageServiceAdapter)new JMSAdapter(this.context), currentContextPath.lookup()), this.scheduledThreadPoolExecutor, new ServletContextConfiguration("com.icesoft.net.messaging", this.context), true, configuration.getAttribute("blockingRequestHandlerContext", "push-server"));
                if (this.coreMessageService.setUpNow()) {
                    this.blockingRequestHandlerContext = URI.create("/").resolve(blockingRequestHandlerContext + "/").toString();
                } else {
                    this.coreMessageService = null;
                }
            }
            if (this.coreMessageService == null) {
                this.coreMessageService = new CoreMessageService(new MessageServiceClient("Core MSC", (MessageServiceAdapter)new HttpAdapter(this.localAddress, this.localPort, this.context), currentContextPath.lookup()), this.scheduledThreadPoolExecutor, (Configuration)new ServletContextConfiguration("com.icesoft.net.messaging", this.context), configuration.getAttribute("blockingRequestHandlerContext", "push-server"));
                if (this.coreMessageService.setUpNow()) {
                    this.blockingRequestHandlerContext = URI.create("/").resolve(blockingRequestHandlerContext + "/").toString();
                } else {
                    this.coreMessageService = null;
                }
            }
            if (this.coreMessageService == null) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)"Push Server not found - the Push Server must be deployed to support multiple asynchronous applications.");
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Adapting to Push environment.");
                }
            }
        }
        if (this.coreMessageService != null) {
            this.coreMessageService.start();
            ContextEventRepeater.setCoreMessageService(this.coreMessageService);
        }
    }

    static {
        String headless = "java.awt.headless";
        if (null == System.getProperty("java.awt.headless")) {
            System.setProperty("java.awt.headless", "true");
        }
    }

    private static class CurrentContextPath
    extends ThreadLocal {
        private CurrentContextPath() {
        }

        public String lookup() {
            return (String)this.get();
        }

        public void attach(String path) {
            this.set(path);
        }

        public void detach() {
            this.set(null);
        }
    }
}

