/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema;

import java.io.IOException;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.ws.commons.schema.SchemaBuilder;
import org.apache.ws.commons.schema.TypeReceiver;
import org.apache.ws.commons.schema.ValidationEventHandler;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.constants.Constants;
import org.apache.ws.commons.schema.extensions.ExtensionRegistry;
import org.apache.ws.commons.schema.resolver.DefaultURIResolver;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.apache.ws.commons.schema.utils.DOMUtil;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.apache.ws.commons.schema.utils.TargetNamespaceValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlSchemaCollection {
    private ExtensionRegistry extReg = new ExtensionRegistry();
    private Map knownNamespaceMap = new HashMap();
    private Map schemas = new HashMap();
    String baseUri = null;
    private NamespacePrefixList namespaceContext;
    private URIResolver schemaResolver = new DefaultURIResolver();
    XmlSchema xsd = new XmlSchema("http://www.w3.org/2001/XMLSchema", this);
    Stack stack = new Stack();
    Map unresolvedTypes = new HashMap();

    public ExtensionRegistry getExtReg() {
        return this.extReg;
    }

    public void setExtReg(ExtensionRegistry extReg) {
        this.extReg = extReg;
    }

    public Map getKnownNamespaceMap() {
        return this.knownNamespaceMap;
    }

    public void setKnownNamespaceMap(Map knownNamespaceMap) {
        this.knownNamespaceMap = knownNamespaceMap;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setSchemaResolver(URIResolver schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public URIResolver getSchemaResolver() {
        return this.schemaResolver;
    }

    public void init() {
        this.addSimpleType(this.xsd, Constants.XSD_ANYSIMPLETYPE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ANYTYPE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_STRING.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_BOOLEAN.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_FLOAT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DOUBLE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_QNAME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DECIMAL.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DURATION.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DATE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_TIME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DATETIME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_DAY.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_MONTH.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_MONTHDAY.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_YEAR.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_YEARMONTH.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NOTATION.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_HEXBIN.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_BASE64.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ANYURI.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_LONG.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_SHORT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_BYTE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_INTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_INT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_POSITIVEINTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NEGATIVEINTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NONPOSITIVEINTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NONNEGATIVEINTEGER.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_UNSIGNEDBYTE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_UNSIGNEDINT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_UNSIGNEDLONG.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_UNSIGNEDSHORT.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NAME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NORMALIZEDSTRING.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NCNAME.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NMTOKEN.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_NMTOKENS.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ENTITY.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ENTITIES.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_ID.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_IDREF.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_IDREFS.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_LANGUAGE.getLocalPart());
        this.addSimpleType(this.xsd, Constants.XSD_TOKEN.getLocalPart());
        if (System.getProperty("org.apache.ws.commons.extensions.ExtensionRegistry") != null) {
            try {
                Class<?> clazz = Class.forName(System.getProperty("org.apache.ws.commons.extensions.ExtensionRegistry"));
                this.extReg = (ExtensionRegistry)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                System.err.println("The specified extension registry class cannot be found!");
            }
            catch (InstantiationException e) {
                System.err.println("The specified extension registry class cannot be instantiated!");
            }
            catch (IllegalAccessException e) {
                System.err.println("The specified extension registry class cannot be accessed!");
            }
        }
    }

    boolean containsSchema(SchemaKey pKey) {
        return this.schemas.containsKey(pKey);
    }

    XmlSchema getKnownSchema(String namespace) {
        return (XmlSchema)this.knownNamespaceMap.get(namespace);
    }

    XmlSchema getSchema(SchemaKey pKey) {
        return (XmlSchema)this.schemas.get(pKey);
    }

    void addSchema(SchemaKey pKey, XmlSchema pSchema) {
        if (this.schemas.containsKey(pKey)) {
            throw new IllegalStateException("A schema with target namespace " + pKey.getNamespace() + " and system ID " + pKey.getSystemId() + " is already present.");
        }
        this.schemas.put(pKey, pSchema);
    }

    private void addSimpleType(XmlSchema schema, String typeName) {
        XmlSchemaSimpleType type = new XmlSchemaSimpleType(schema);
        type.setName(typeName);
        schema.addType(type);
    }

    public XmlSchema read(Reader r, ValidationEventHandler veh) {
        return this.read(new InputSource(r), veh);
    }

    XmlSchema read(InputSource inputSource, ValidationEventHandler veh, TargetNamespaceValidator namespaceValidator) {
        try {
            DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
            docFac.setNamespaceAware(true);
            DocumentBuilder builder = docFac.newDocumentBuilder();
            Document doc = null;
            doc = this.parse_doPriv(inputSource, builder, doc);
            return this.read(doc, inputSource.getSystemId(), veh, namespaceValidator);
        }
        catch (ParserConfigurationException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (IOException e) {
            throw new XmlSchemaException(e.getMessage());
        }
        catch (SAXException e) {
            throw new XmlSchemaException(e.getMessage());
        }
    }

    private Document parse_doPriv(final InputSource inputSource, final DocumentBuilder builder, Document doc) throws IOException, SAXException {
        block3: {
            try {
                doc = (Document)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException, SAXException {
                        return builder.parse(inputSource);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception exception = e.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof SAXException)) break block3;
                throw (SAXException)exception;
            }
        }
        return doc;
    }

    public XmlSchema read(InputSource inputSource, ValidationEventHandler veh) {
        return this.read(inputSource, veh, null);
    }

    public XmlSchema read(Source source, ValidationEventHandler veh) {
        if (source instanceof SAXSource) {
            return this.read(((SAXSource)source).getInputSource(), veh);
        }
        if (source instanceof DOMSource) {
            Node node = ((DOMSource)source).getNode();
            if (node instanceof Document) {
                node = ((Document)node).getDocumentElement();
            }
            return this.read((Document)node, veh);
        }
        if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            InputSource isource = new InputSource(ss.getSystemId());
            isource.setByteStream(ss.getInputStream());
            isource.setCharacterStream(ss.getReader());
            isource.setPublicId(ss.getPublicId());
            return this.read(isource, veh);
        }
        InputSource isource = new InputSource(source.getSystemId());
        return this.read(isource, veh);
    }

    public XmlSchema read(Document doc, ValidationEventHandler veh) {
        SchemaBuilder builder = new SchemaBuilder(this, null);
        return builder.build(doc, null, veh);
    }

    public XmlSchema read(Element elem) {
        SchemaBuilder builder = new SchemaBuilder(this, null);
        XmlSchema xmlSchema = builder.handleXmlSchemaElement(elem, null);
        xmlSchema.setInputEncoding(DOMUtil.getXmlEncoding(elem.getOwnerDocument()));
        return xmlSchema;
    }

    public XmlSchema read(Document doc, String uri, ValidationEventHandler veh) {
        return this.read(doc, uri, veh, null);
    }

    public XmlSchema read(Document doc, String uri, ValidationEventHandler veh, TargetNamespaceValidator validator) {
        SchemaBuilder builder = new SchemaBuilder(this, validator);
        XmlSchema schema = builder.build(doc, uri, veh);
        schema.setInputEncoding(DOMUtil.getInputEncoding(doc));
        return schema;
    }

    public XmlSchema read(Element elem, String uri) {
        SchemaBuilder builder = new SchemaBuilder(this, null);
        XmlSchema xmlSchema = builder.handleXmlSchemaElement(elem, uri);
        xmlSchema.setInputEncoding(DOMUtil.getInputEncoding(elem.getOwnerDocument()));
        return xmlSchema;
    }

    public XmlSchemaCollection() {
        this.init();
    }

    public XmlSchema[] getXmlSchema(String systemId) {
        if (systemId == null) {
            systemId = "";
        }
        ArrayList result = new ArrayList();
        Iterator iter = this.schemas.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!((SchemaKey)entry.getKey()).getSystemId().equals(systemId)) continue;
            result.add(entry.getValue());
        }
        return result.toArray(new XmlSchema[result.size()]);
    }

    public XmlSchema[] getXmlSchemas() {
        Collection c = this.schemas.values();
        return c.toArray(new XmlSchema[c.size()]);
    }

    public XmlSchemaElement getElementByQName(QName qname) {
        String uri = qname.getNamespaceURI();
        Iterator iter = this.schemas.entrySet().iterator();
        while (iter.hasNext()) {
            XmlSchemaElement element;
            Map.Entry entry = iter.next();
            if (!((SchemaKey)entry.getKey()).getNamespace().equals(uri) || (element = ((XmlSchema)entry.getValue()).getElementByName(qname)) == null) continue;
            return element;
        }
        return null;
    }

    public XmlSchemaType getTypeByQName(QName schemaTypeName) {
        String uri = schemaTypeName.getNamespaceURI();
        Iterator iter = this.schemas.entrySet().iterator();
        while (iter.hasNext()) {
            XmlSchemaType type;
            Map.Entry entry = iter.next();
            if (!((SchemaKey)entry.getKey()).getNamespace().equals(uri) || (type = ((XmlSchema)entry.getValue()).getTypeByName(schemaTypeName)) == null) continue;
            return type;
        }
        return null;
    }

    public XmlSchemaAttribute getAttributeByQName(QName schemaAttributeName) {
        String uri = schemaAttributeName.getNamespaceURI();
        Iterator iter = this.schemas.entrySet().iterator();
        while (iter.hasNext()) {
            XmlSchemaAttribute attribute;
            Map.Entry entry = iter.next();
            if (!((SchemaKey)entry.getKey()).getNamespace().equals(uri) || (attribute = ((XmlSchema)entry.getValue()).getAttributeByName(schemaAttributeName)) == null) continue;
            return attribute;
        }
        return null;
    }

    public XmlSchema schemaForNamespace(String uri) {
        Iterator iter = this.schemas.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!((SchemaKey)entry.getKey()).getNamespace().equals(uri)) continue;
            return (XmlSchema)entry.getValue();
        }
        return null;
    }

    void addUnresolvedType(QName type, TypeReceiver receiver) {
        ArrayList<TypeReceiver> receivers = (ArrayList<TypeReceiver>)this.unresolvedTypes.get(type);
        if (receivers == null) {
            receivers = new ArrayList<TypeReceiver>();
            this.unresolvedTypes.put(type, receivers);
        }
        receivers.add(receiver);
    }

    void resolveType(QName typeName, XmlSchemaType type) {
        ArrayList receivers = (ArrayList)this.unresolvedTypes.get(typeName);
        if (receivers == null) {
            return;
        }
        Iterator i = receivers.iterator();
        while (i.hasNext()) {
            TypeReceiver receiver = (TypeReceiver)i.next();
            receiver.setType(type);
        }
        this.unresolvedTypes.remove(typeName);
    }

    public NamespacePrefixList getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(NamespacePrefixList namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public void push(SchemaKey pKey) {
        this.stack.push(pKey);
    }

    public void pop() {
        this.stack.pop();
    }

    public boolean check(SchemaKey pKey) {
        return this.stack.indexOf(pKey) == -1;
    }

    public String toString() {
        return super.toString() + "[" + this.schemas.toString() + "]";
    }

    static class SchemaKey {
        private final String namespace;
        private final String systemId;

        SchemaKey(String pNamespace, String pSystemId) {
            this.namespace = pNamespace == null ? "" : pNamespace;
            this.systemId = pSystemId == null ? "" : pSystemId;
        }

        String getNamespace() {
            return this.namespace;
        }

        String getSystemId() {
            return this.systemId;
        }

        public int hashCode() {
            int PRIME = 31;
            return (31 + this.namespace.hashCode()) * 31 + this.systemId.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SchemaKey other = (SchemaKey)obj;
            return this.namespace.equals(other.namespace) && this.systemId.equals(other.systemId);
        }

        public String toString() {
            return "".equals(this.namespace) ? this.systemId : "{" + this.namespace + "}" + this.systemId;
        }
    }
}

