/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.push.server;

import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.icefaces.push.server.UpdatedViews;
import org.icefaces.push.server.UpdatedViewsManager;
import org.icefaces.push.server.UpdatedViewsQueueExceededException;

public class UpdatedViewsQueue {
    private static final Log LOG = LogFactory.getLog((Class)UpdatedViewsQueue.class);
    protected final String iceFacesId;
    protected final TreeSet updatedViewsQueue = new TreeSet();
    protected int size;
    protected UpdatedViewsManager updatedViewsManager;

    public UpdatedViewsQueue(String iceFacesId, UpdatedViewsManager updatedViewsManager) {
        this.iceFacesId = iceFacesId;
        if (updatedViewsManager != null) {
            this.updatedViewsManager = updatedViewsManager;
            this.size = this.updatedViewsManager.getUpdatedViewsQueueSize();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created " + this));
        }
    }

    public void add(UpdatedViews updatedViews) throws UpdatedViewsQueueExceededException {
        if (updatedViews != null && updatedViews.getICEfacesID().equals(this.iceFacesId)) {
            if (this.updatedViewsManager != null && this.getSize() == this.size) {
                throw new UpdatedViewsQueueExceededException();
            }
            this.updatedViewsQueue.add(updatedViews);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("UpdatedViews added to " + this));
            }
        }
    }

    public void addAll(UpdatedViewsQueue updatedViewsQueue) throws UpdatedViewsQueueExceededException {
        if (updatedViewsQueue != null && !updatedViewsQueue.isEmpty() && updatedViewsQueue.iceFacesId.equals(this.iceFacesId)) {
            Iterator _updatedViews = updatedViewsQueue.iterator();
            while (_updatedViews.hasNext()) {
                this.add((UpdatedViews)_updatedViews.next());
            }
        }
    }

    public void clear() {
        this.updatedViewsQueue.clear();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Cleared " + this));
        }
    }

    public String getICEfacesID() {
        return this.iceFacesId;
    }

    public long getSequenceNumber() {
        if (this.updatedViewsQueue.size() != 0) {
            return ((UpdatedViews)this.updatedViewsQueue.last()).getSequenceNumber();
        }
        return 0L;
    }

    public int getSize() {
        return this.updatedViewsQueue.size();
    }

    public boolean isEmpty() {
        return this.updatedViewsQueue.isEmpty();
    }

    public Iterator iterator() {
        return this.updatedViewsQueue.iterator();
    }

    public void purge(long sequenceNumber) {
        if (sequenceNumber > 0L) {
            UpdatedViews _updatedViews;
            Iterator _updatedViewsIterator = this.iterator();
            while (_updatedViewsIterator.hasNext() && (_updatedViews = (UpdatedViews)_updatedViewsIterator.next()).getSequenceNumber() <= sequenceNumber) {
                _updatedViewsIterator.remove();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Purged up to " + sequenceNumber + " from " + this));
            }
        }
    }

    public String toString() {
        return "UpdatedViewsQueue [" + this.iceFacesId + "]:\r\n" + "        sequence number : " + this.getSequenceNumber() + "\r\n" + "        size            : " + this.getSize();
    }
}

