/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jivesoftware.smackx.workgroup.util.ReverseListIterator;

public final class ModelUtil {
    private ModelUtil() {
    }

    public static final boolean areEqual(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static final boolean areBooleansEqual(Boolean b1, Boolean b2) {
        return b1 == Boolean.TRUE && b2 == Boolean.TRUE || b1 != Boolean.TRUE && b2 != Boolean.TRUE;
    }

    public static final boolean areDifferent(Object o1, Object o2) {
        return !ModelUtil.areEqual(o1, o2);
    }

    public static final boolean areBooleansDifferent(Boolean b1, Boolean b2) {
        return !ModelUtil.areBooleansEqual(b1, b2);
    }

    public static final boolean hasNonNullElement(Object[] array) {
        if (array != null) {
            int n = array.length;
            for (int i = 0; i < n; ++i) {
                if (array[i] == null) continue;
                return true;
            }
        }
        return false;
    }

    public static final String concat(String[] strs) {
        return ModelUtil.concat(strs, " ");
    }

    public static final String concat(String[] strs, String delim) {
        if (strs != null) {
            StringBuilder buf = new StringBuilder();
            for (String str : strs) {
                if (str == null) continue;
                buf.append(str).append(delim);
            }
            int length = buf.length();
            if (length > 0) {
                buf.setLength(length - 1);
            }
            return buf.toString();
        }
        return "";
    }

    public static final boolean hasLength(String s) {
        return s != null && s.length() > 0;
    }

    public static final String nullifyIfEmpty(String s) {
        return ModelUtil.hasLength(s) ? s : null;
    }

    public static final String nullifyingToString(Object o) {
        return o != null ? ModelUtil.nullifyIfEmpty(o.toString()) : null;
    }

    public static boolean hasStringChanged(String oldString, String newString) {
        if (oldString == null && newString == null) {
            return false;
        }
        if (oldString == null && newString != null || oldString != null && newString == null) {
            return true;
        }
        return !oldString.equals(newString);
    }

    public static String getTimeFromLong(long diff) {
        String HOURS = "h";
        String MINUTES = "min";
        String SECONDS = "sec";
        long MS_IN_A_DAY = 86400000L;
        long MS_IN_AN_HOUR = 3600000L;
        long MS_IN_A_MINUTE = 60000L;
        long MS_IN_A_SECOND = 1000L;
        Date currentTime = new Date();
        long numDays = diff / 86400000L;
        long numHours = (diff %= 86400000L) / 3600000L;
        long numMinutes = (diff %= 3600000L) / 60000L;
        long numSeconds = (diff %= 60000L) / 1000L;
        long numMilliseconds = diff %= 1000L;
        StringBuilder buf = new StringBuilder();
        if (numHours > 0L) {
            buf.append(numHours + " " + "h" + ", ");
        }
        if (numMinutes > 0L) {
            buf.append(numMinutes + " " + "min" + ", ");
        }
        buf.append(numSeconds + " " + "sec");
        String result = buf.toString();
        return result;
    }

    public static List iteratorAsList(Iterator i) {
        ArrayList list = new ArrayList(10);
        while (i.hasNext()) {
            list.add(i.next());
        }
        return list;
    }

    public static Iterator reverseListIterator(ListIterator i) {
        return new ReverseListIterator(i);
    }
}

