/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.net.messaging;

import com.icesoft.net.messaging.Message;
import com.icesoft.net.messaging.MessageServiceClient;
import com.icesoft.net.messaging.MessageServiceException;
import com.icesoft.net.messaging.PublishTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessagePipeline {
    private static final Log LOG = LogFactory.getLog((Class)MessagePipeline.class);
    private MessageServiceClient messageServiceClient;
    private String topicName;
    private Message message;
    private PublishTask publishTask;
    private final Object messageLock = new Object();

    public MessagePipeline(MessageServiceClient messageServiceClient, String topicName) {
        this.messageServiceClient = messageServiceClient;
        this.topicName = topicName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Message message) {
        Object object = this.messageLock;
        synchronized (object) {
            if (this.message == null) {
                this.message = message;
                this.publishTask = new PublishTask(this);
                if (this.message.getLength() >= this.messageServiceClient.getMessageServiceConfiguration().getMessageMaxLength()) {
                    this.messageServiceClient.schedule(this.publishTask, 0L);
                } else {
                    this.messageServiceClient.schedule(this.publishTask, this.messageServiceClient.getMessageServiceConfiguration().getMessageMaxDelay());
                }
            } else {
                this.message.append(message);
                if (this.message.getLength() >= this.messageServiceClient.getMessageServiceConfiguration().getMessageMaxLength()) {
                    this.publishTask.cancel();
                    this.publishTask = new PublishTask(this);
                    this.messageServiceClient.schedule(this.publishTask, 0L);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publish() {
        Object object = this.messageLock;
        synchronized (object) {
            try {
                this.messageServiceClient.getMessageServiceAdapter().publish(this.message, this.topicName);
                this.publishTask.cancel();
                this.publishTask = null;
                this.message = null;
            }
            catch (MessageServiceException exception) {
                LOG.error((Object)"", (Throwable)exception);
                if (this.messageServiceClient.getAdministrator().reconnectNow()) {
                    this.publish();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(exception.getMessage() + "\r\n" + "Unable to publish message:\r\n\r\n" + this.message));
                }
                this.publishTask.cancel();
                this.publishTask = null;
                this.message = null;
            }
        }
    }
}

