/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.deployment.scheduler;

import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.axis2.deployment.scheduler.DeploymentIterator;
import org.apache.axis2.deployment.scheduler.SchedulerTask;
import org.apache.axis2.java.security.AccessController;

public class Scheduler {
    private final Timer timer = (Timer)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new Timer(true);
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reschedule(SchedulerTask schedulerTask, DeploymentIterator iterator) {
        Date time = iterator.next();
        if (time == null) {
            schedulerTask.cancel();
        } else {
            Object object = schedulerTask.lock;
            synchronized (object) {
                if (schedulerTask.state != 2) {
                    schedulerTask.timerTask = new SchedulerTimerTask(schedulerTask, iterator);
                    this.timer.schedule(schedulerTask.timerTask, time);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SchedulerTask schedulerTask, DeploymentIterator iterator) {
        Date time = iterator.next();
        if (time == null) {
            schedulerTask.cancel();
        } else {
            Object object = schedulerTask.lock;
            synchronized (object) {
                schedulerTask.state = 1;
                schedulerTask.timerTask = new SchedulerTimerTask(schedulerTask, iterator);
                this.timer.schedule(schedulerTask.timerTask, time);
            }
        }
    }

    public void cleanup() {
        this.timer.cancel();
    }

    public class SchedulerTimerTask
    extends TimerTask {
        private DeploymentIterator iterator;
        private SchedulerTask schedulerTask;

        public SchedulerTimerTask(SchedulerTask schedulerTask, DeploymentIterator iterator) {
            this.schedulerTask = schedulerTask;
            this.iterator = iterator;
        }

        public void run() {
            this.schedulerTask.run();
            Scheduler.this.reschedule(this.schedulerTask, this.iterator);
        }
    }
}

