/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.axisChart;

import java.awt.font.FontRenderContext;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.axisChart.ScatterPlotChart;
import org.krysalis.jcharts.axisChart.axis.Axis;
import org.krysalis.jcharts.axisChart.axis.XAxis;
import org.krysalis.jcharts.axisChart.axis.YAxis;
import org.krysalis.jcharts.axisChart.axis.scale.AutomaticScaleCalculator;
import org.krysalis.jcharts.axisChart.axis.scale.ScaleCalculator;
import org.krysalis.jcharts.axisChart.axis.scale.UserDefinedScaleCalculator;
import org.krysalis.jcharts.chartData.interfaces.IAxisPlotDataSet;
import org.krysalis.jcharts.chartData.interfaces.IScatterPlotDataSeries;
import org.krysalis.jcharts.chartData.interfaces.IScatterPlotDataSet;
import org.krysalis.jcharts.chartData.processors.AxisChartDataProcessor;
import org.krysalis.jcharts.chartData.processors.ScatterPlotDataProcessor;
import org.krysalis.jcharts.chartText.NumericTagGroup;
import org.krysalis.jcharts.imageMap.ImageMap;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.DataAxisProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.test.HTMLChartTestable;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.types.ChartType;

public class ScatterPlotAxisChart
extends AxisChart
implements HTMLChartTestable {
    public ScatterPlotAxisChart(IScatterPlotDataSeries iScatterPlotDataSeries, ChartProperties chartProperties, AxisProperties axisProperties, LegendProperties legendProperties, int n, int n2) {
        super(iScatterPlotDataSeries, chartProperties, axisProperties, legendProperties, n, n2);
    }

    public AxisChartDataProcessor createAxisChartDataProcessor() {
        return new ScatterPlotDataProcessor();
    }

    protected NumericTagGroup setupDataAxisProperties(Axis axis, DataAxisProperties dataAxisProperties, AxisChartDataProcessor axisChartDataProcessor, FontRenderContext fontRenderContext) {
        Object object;
        ScatterPlotDataProcessor scatterPlotDataProcessor = (ScatterPlotDataProcessor)axisChartDataProcessor;
        if (dataAxisProperties.getScaleCalculator() == null) {
            if (dataAxisProperties.hasUserDefinedScale()) {
                object = new UserDefinedScaleCalculator(dataAxisProperties.getUserDefinedMinimumValue(), dataAxisProperties.getUserDefinedIncrement());
            } else {
                object = new AutomaticScaleCalculator();
                if (axis instanceof XAxis) {
                    ((ScaleCalculator)object).setMaxValue(scatterPlotDataProcessor.getMaxValue());
                    ((ScaleCalculator)object).setMinValue(scatterPlotDataProcessor.getMinValue());
                } else {
                    ((ScaleCalculator)object).setMaxValue(scatterPlotDataProcessor.getyMax());
                    ((ScaleCalculator)object).setMinValue(scatterPlotDataProcessor.getyMin());
                }
            }
            axis.setScaleCalculator((ScaleCalculator)object);
        } else {
            axis.setScaleCalculator(dataAxisProperties.getScaleCalculator());
            if (axis instanceof XAxis) {
                axis.getScaleCalculator().setMaxValue(scatterPlotDataProcessor.getMaxValue());
                axis.getScaleCalculator().setMinValue(scatterPlotDataProcessor.getMinValue());
            } else {
                axis.getScaleCalculator().setMaxValue(scatterPlotDataProcessor.getyMax());
                axis.getScaleCalculator().setMinValue(scatterPlotDataProcessor.getyMin());
            }
        }
        axis.getScaleCalculator().setRoundingPowerOfTen(dataAxisProperties.getRoundToNearest());
        axis.getScaleCalculator().setNumberOfScaleItems(dataAxisProperties.getNumItems());
        axis.getScaleCalculator().computeScaleValues();
        object = new NumericTagGroup(dataAxisProperties.getScaleChartFont(), fontRenderContext, dataAxisProperties.useDollarSigns(), dataAxisProperties.usePercentSigns(), dataAxisProperties.useCommas(), dataAxisProperties.getRoundToNearest());
        ((NumericTagGroup)object).createAxisScaleLabels(axis.getScaleCalculator());
        return object;
    }

    protected void setupAxis(AxisChartDataProcessor axisChartDataProcessor, FontRenderContext fontRenderContext) {
        DataAxisProperties dataAxisProperties = (DataAxisProperties)this.getAxisProperties().getXAxisProperties();
        this.xAxis = new XAxis(this, dataAxisProperties.getNumItems());
        NumericTagGroup numericTagGroup = this.setupDataAxisProperties(this.xAxis, dataAxisProperties, axisChartDataProcessor, fontRenderContext);
        this.xAxis.setAxisLabelsGroup(numericTagGroup);
        dataAxisProperties = (DataAxisProperties)this.getAxisProperties().getYAxisProperties();
        this.yAxis = new YAxis(this, dataAxisProperties.getNumItems());
        numericTagGroup = this.setupDataAxisProperties(this.yAxis, dataAxisProperties, axisChartDataProcessor, fontRenderContext);
        this.yAxis.setAxisLabelsGroup(numericTagGroup);
        this.yAxis.computeMinimumWidthNeeded(super.getIAxisDataSeries().getYAxisTitle());
        this.xAxis.computeMinimumHeightNeeded(super.getIAxisDataSeries().getXAxisTitle());
    }

    protected void deriveAxisValues() {
        this.xAxis.computeLabelFilter();
        this.xAxis.computeShouldTickStartAtYAxis(super.getIAxisDataSeries(), this.axisProperties.getXAxisProperties());
        this.xAxis.computeScalePixelWidthDataAxis(this.axisProperties.getXAxisProperties());
        this.xAxis.computeOneUnitPixelSize(this.xAxis.getScalePixelWidth(), this.xAxis.getScaleCalculator().getIncrement());
        float f = (float)((double)this.xAxis.getOrigin() + (double)this.xAxis.getScalePixelWidth() * -this.xAxis.getScaleCalculator().getMinValue() / this.xAxis.getScaleCalculator().getIncrement());
        this.xAxis.setZeroLineCoordinate(f);
        this.yAxis.computeScalePixelWidthDataAxis(this.axisProperties.getYAxisProperties());
        this.yAxis.computeOneUnitPixelSize(this.yAxis.getScalePixelWidth(), this.yAxis.getScaleCalculator().getIncrement());
        f = (float)((double)this.yAxis.getOrigin() - (double)this.yAxis.getScalePixelWidth() * -this.yAxis.getScaleCalculator().getMinValue() / this.yAxis.getScaleCalculator().getIncrement());
        this.yAxis.setZeroLineCoordinate(f);
        this.xAxis.computeTickStart();
    }

    protected void overlayCharts() throws PropertyException {
        IAxisPlotDataSet iAxisPlotDataSet = super.getIAxisDataSeries().getIAxisPlotDataSet(ChartType.SCATTER_PLOT);
        ScatterPlotChart.render(this, (IScatterPlotDataSet)iAxisPlotDataSet);
    }

    public void toHTML(HTMLGenerator hTMLGenerator, String string, ImageMap imageMap) {
        hTMLGenerator.chartTableStart(this.getClass().getName(), string, imageMap);
        hTMLGenerator.chartTableRowStart();
        this.axisProperties.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        hTMLGenerator.chartTableRowStart();
        this.xAxis.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        hTMLGenerator.chartTableRowStart();
        this.yAxis.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        hTMLGenerator.chartTableRowStart();
        super.getChartProperties().toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
        if (super.getLegend() != null) {
            hTMLGenerator.chartTableRowStart();
            this.getLegend().toHTML(hTMLGenerator);
            hTMLGenerator.chartTableRowEnd();
        }
        hTMLGenerator.chartTableEnd();
    }
}

