/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.chartData;

import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.interfaces.IScatterPlotDataSet;
import org.krysalis.jcharts.properties.ChartTypeProperties;
import org.krysalis.jcharts.properties.ScatterPlotProperties;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.test.HTMLTestable;
import org.krysalis.jcharts.types.ChartType;

public class ScatterPlotDataSet
implements IScatterPlotDataSet,
HTMLTestable {
    private static Point2D.Double POINT = new Point2D.Double();
    private ArrayList data = new ArrayList();
    private ArrayList legendLabels = new ArrayList();
    private ArrayList paints = new ArrayList();
    private ScatterPlotProperties scatterPlotProperties;
    private int numDataItems = -1;

    public ScatterPlotDataSet(ScatterPlotProperties scatterPlotProperties) {
        this.scatterPlotProperties = scatterPlotProperties;
    }

    public final ChartType getChartType() {
        return ChartType.SCATTER_PLOT;
    }

    public void addDataPoints(Point2D.Double[] doubleArray, Paint paint, String string) {
        this.data.add(doubleArray);
        this.paints.add(paint);
        this.legendLabels.add(string);
        this.numDataItems = doubleArray.length;
    }

    public void validate() throws ChartDataException {
        for (int i = 0; i < this.data.size(); ++i) {
            Point2D.Double[] doubleArray = (Point2D.Double[])this.data.get(i);
            if (doubleArray.length != this.numDataItems) {
                throw new ChartDataException("All Arrays of Point Objects must have the same length.");
            }
            if (this.paints.get(i) != null) continue;
            throw new ChartDataException("The 'Paint' implementation can not be NULL.");
        }
        if (this.scatterPlotProperties == null) {
            throw new ChartDataException("ScatterPlotProperties can not be NULL.");
        }
    }

    public Point2D.Double getValue(int n, int n2) {
        return ((Point2D.Double[])this.data.get(n))[n2];
    }

    public final String getLegendLabel(int n) {
        if (this.legendLabels == null) {
            return null;
        }
        return (String)this.legendLabels.get(n);
    }

    public int getNumberOfLegendLabels() {
        if (this.legendLabels == null) {
            return 0;
        }
        return this.legendLabels.size();
    }

    public Paint getPaint(int n) {
        return (Paint)this.paints.get(n);
    }

    public ChartTypeProperties getChartTypeProperties() {
        return this.scatterPlotProperties;
    }

    public int getNumberOfDataSets() {
        return this.data.size();
    }

    public int getNumberOfDataItems() {
        return this.numDataItems;
    }

    public static final Point2D.Double createPoint2DDouble() {
        return (Point2D.Double)POINT.clone();
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        hTMLGenerator.addTableRow("data", HTMLGenerator.arrayToString(this.data.toArray(new Point2D.Double[this.legendLabels.size()])));
        if (this.legendLabels != null) {
            hTMLGenerator.addTableRow("legendLabels", HTMLGenerator.arrayToString(this.legendLabels.toArray(new String[this.legendLabels.size()])));
        }
        hTMLGenerator.addTableRow("paints", HTMLGenerator.arrayToString(this.paints.toArray(new Paint[this.paints.size()])));
        hTMLGenerator.propertiesTableEnd();
        hTMLGenerator.chartTableRowStart();
        this.scatterPlotProperties.toHTML(hTMLGenerator);
        hTMLGenerator.chartTableRowEnd();
    }
}

