/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.properties;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.krysalis.jcharts.Chart;
import org.krysalis.jcharts.properties.ChartTypeProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.properties.util.ChartFont;
import org.krysalis.jcharts.test.HTMLGenerator;
import org.krysalis.jcharts.test.HTMLTestable;

public final class RadarChartProperties
extends ChartTypeProperties
implements HTMLTestable {
    private boolean showGridLines = true;
    private boolean fillRadar = true;
    private double max = Double.NaN;
    private double increment = Double.NaN;
    private ChartFont axisLabelChartFont = ChartFont.DEFAULT_AXIS_TITLE;
    private ChartFont titleChartFont = ChartFont.DEFAULT_CHART_TITLE;
    private NumberFormat numberFormat = new DecimalFormat();

    public RadarChartProperties() {
        this.numberFormat.setMaximumFractionDigits(2);
    }

    public boolean getShowGridLines() {
        return this.showGridLines;
    }

    public void setShowGridLines(boolean bl) {
        this.showGridLines = bl;
    }

    public boolean getFillRadar() {
        return this.fillRadar;
    }

    public void setFillRadar(boolean bl) {
        this.fillRadar = bl;
    }

    public ChartFont getTitleChartFont() {
        return this.titleChartFont;
    }

    public void setTitleChartFont(ChartFont chartFont) {
        this.titleChartFont = chartFont;
    }

    public ChartFont getAxisLabelChartFont() {
        return this.axisLabelChartFont;
    }

    public void setAxisLabelChartFont(ChartFont chartFont) {
        this.axisLabelChartFont = chartFont;
    }

    public void setGridLabelFormat(NumberFormat numberFormat) {
        if (numberFormat != null) {
            this.numberFormat = numberFormat;
        }
    }

    public NumberFormat getGridLabelFormat() {
        return this.numberFormat;
    }

    public double getScaleMaxValue() {
        return this.max;
    }

    public void setScaleMaxValue(double d) {
        this.max = d;
    }

    public double getScaleIncrement() {
        return this.increment;
    }

    public void setScaleIncrement(double d) {
        this.increment = d;
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart("RadarChartProperties");
        hTMLGenerator.addTableRow("Show gridlines", new Boolean(this.showGridLines));
        hTMLGenerator.addTableRow("Fill radar", new Boolean(this.fillRadar));
        hTMLGenerator.addTableRow("Scale max value", new Double(this.max));
        hTMLGenerator.addTableRow("Scale increment", new Double(this.increment));
        hTMLGenerator.propertiesTableEnd();
    }

    public void validate(Chart chart) throws PropertyException {
    }
}

