/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.jcharts.test;

import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import org.krysalis.jcharts.axisChart.AxisChart;
import org.krysalis.jcharts.chartData.AxisChartDataSet;
import org.krysalis.jcharts.chartData.ChartDataException;
import org.krysalis.jcharts.chartData.DataSeries;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.ChartTypeProperties;
import org.krysalis.jcharts.properties.LegendProperties;
import org.krysalis.jcharts.properties.PointChartProperties;
import org.krysalis.jcharts.properties.PropertyException;
import org.krysalis.jcharts.test.AxisChartTestBase;
import org.krysalis.jcharts.test.ChartTestDriver;
import org.krysalis.jcharts.test.TestDataGenerator;
import org.krysalis.jcharts.types.ChartType;

class PointTestDriver
extends AxisChartTestBase {
    PointTestDriver() {
    }

    boolean supportsImageMap() {
        return true;
    }

    static ChartTypeProperties getChartTypeProperties(int n) {
        Shape[] shapeArray = new Shape[]{PointChartProperties.SHAPE_DIAMOND, PointChartProperties.SHAPE_TRIANGLE};
        boolean[] blArray = new boolean[]{true, true};
        Paint[] paintArray = new Paint[]{Color.black, Color.blue};
        return new PointChartProperties(shapeArray, blArray, paintArray);
    }

    DataSeries getDataSeries() throws ChartDataException {
        int n = (int)TestDataGenerator.getRandomNumber(13.0, 15.0);
        int n2 = 2;
        DataSeries dataSeries = super.createDataSeries(n);
        AxisChartDataSet axisChartDataSet = super.createAxisChartDataSet(ChartType.POINT, PointTestDriver.getChartTypeProperties(n2), n2, n, 0, 5000);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        return dataSeries;
    }

    public static void main(String[] stringArray) throws PropertyException, ChartDataException {
        Shape[] shapeArray = new Shape[]{PointChartProperties.SHAPE_DIAMOND, PointChartProperties.SHAPE_TRIANGLE};
        boolean[] blArray = new boolean[]{true, true};
        Paint[] paintArray = new Paint[]{Color.black, Color.blue};
        PointChartProperties pointChartProperties = new PointChartProperties(shapeArray, blArray, paintArray);
        double[][] dArrayArray = new double[][]{{280.0, 16.0, 150.0, 90.0, 60.0, 200.0, 150.0, 60.0}, {80.0, 216.0, 10.0, 30.0, 15.0, 90.0, 150.0, 87.0}};
        Paint[] paintArray2 = new Paint[]{Color.yellow, Color.blue};
        String[] stringArray2 = new String[]{"Test Legend Label", "second set"};
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(dArrayArray, stringArray2, paintArray2, ChartType.POINT, pointChartProperties);
        String[] stringArray3 = new String[]{"1900", "1950", "2000", "2050", "3000", "3050", "4000", "4050"};
        DataSeries dataSeries = new DataSeries(stringArray3, "Cookies", "Years", null);
        dataSeries.addIAxisPlotDataSet(axisChartDataSet);
        ChartProperties chartProperties = new ChartProperties();
        AxisProperties axisProperties = new AxisProperties(false);
        LegendProperties legendProperties = new LegendProperties();
        AxisChart axisChart = new AxisChart(dataSeries, chartProperties, axisProperties, legendProperties, 500, 400);
        axisChart.renderWithImageMap();
        ChartTestDriver.exportImage(axisChart, "pointChartTest.png");
    }
}

