/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HashMapUpdateLockable<K, V>
extends HashMap<K, V> {
    private UpdateLock updateLock = new UpdateLock(false);

    HashMapUpdateLockable() {
    }

    HashMapUpdateLockable(int size) {
        super(size);
    }

    HashMapUpdateLockable(Map<K, V> map) {
        super(map);
    }

    @Override
    public V put(K key, V value) {
        this.checkUpdateLock(true);
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.checkUpdateLock(true);
        super.putAll(map);
    }

    @Override
    public V remove(Object key) {
        this.checkUpdateLock(true);
        return super.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void lockForUpdate() {
        UpdateLock updateLock = this.updateLock;
        synchronized (updateLock) {
            this.updateLock.setLock(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unlockForUpdate() {
        UpdateLock updateLock = this.updateLock;
        synchronized (updateLock) {
            this.updateLock.setLock(false);
            this.updateLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkUpdateLock(boolean wait) {
        boolean isLocked = false;
        UpdateLock updateLock = this.updateLock;
        synchronized (updateLock) {
            if (wait) {
                while (this.updateLock.isLocked()) {
                    try {
                        this.updateLock.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            isLocked = this.updateLock.isLocked();
        }
        return isLocked;
    }

    class UpdateLock {
        private boolean isLocked = false;

        UpdateLock(boolean isLocked) {
            this.isLocked = isLocked;
        }

        void setLock(boolean lockValue) {
            this.isLocked = lockValue;
        }

        boolean isLocked() {
            return this.isLocked;
        }
    }
}

