/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.def;

import org.jibx.binding.def.BindingDefinition;

public class NamespaceDefinition {
    static final int NODEFAULT_USAGE = 0;
    static final int ELEMENTS_USAGE = 1;
    static final int ATTRIBUTES_USAGE = 2;
    static final int ALLDEFAULT_USAGE = 3;
    private String m_uri;
    private String m_prefix;
    private int m_index;
    private boolean m_elementDefault;
    private boolean m_attributeDefault;

    public NamespaceDefinition(String uri, String prefix, int usage) {
        this.m_uri = uri;
        this.m_prefix = prefix;
        this.m_elementDefault = usage == 3 || usage == 1;
        this.m_attributeDefault = usage == 3 || usage == 2;
    }

    public boolean isAttributeDefault() {
        return this.m_attributeDefault;
    }

    public boolean isElementDefault() {
        return this.m_elementDefault;
    }

    public void setPrefix(String prefix) {
        this.m_prefix = prefix;
    }

    public String getPrefix() {
        return this.m_prefix;
    }

    public String getUri() {
        return this.m_uri;
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    public int getIndex() {
        return this.m_index;
    }

    public static NamespaceDefinition buildNamespace(String uri, String prefix) {
        return new NamespaceDefinition(uri, prefix, 0);
    }

    public void print(int depth) {
        BindingDefinition.indent(depth);
        System.out.print("namespace " + this.m_uri);
        if (this.m_attributeDefault || this.m_elementDefault) {
            System.out.print(" (default ");
            if (this.m_elementDefault) {
                System.out.print("elements");
                if (this.m_attributeDefault) {
                    System.out.print(" and attributes");
                }
            } else {
                System.out.print("attributes");
            }
            System.out.print(')');
        }
        if (this.m_prefix != null) {
            System.out.print(" (prefix " + this.m_prefix + ")");
        }
        System.out.println();
    }
}

