#include "Python.h"
#include "bacula.h"

static PyObject *
clibbac_bin_to_base64(PyObject *self, PyObject *args)
{
    char *binstr;
    int compatible;
    char *retbuf;
    size_t retlen;
    PyObject *result;

    if (!PyArg_ParseTuple(args, "si", &binstr, &compatible))
        return NULL;

    retlen = strlen(binstr) * 2 + 2;

    retbuf = (char *) PyMem_Malloc(retlen);
    if (retbuf == NULL)
    	return NULL;

    bin_to_base64(retbuf, retlen,
                  binstr, strlen(binstr), compatible);

    result = Py_BuildValue("s", retbuf);
    PyMem_Free(retbuf);

    return result;
}

static PyObject *
clibbac_hmac_md5(PyObject *self, PyObject *args)
{
    const char *challenge, *password;
    char retbuf[20];

    if (!PyArg_ParseTuple(args, "ss", &challenge, &password))
        return NULL;
    hmac_md5((u_int8_t*) challenge, strlen(challenge),
    		(u_int8_t*) password, strlen(password),
    		(u_int8_t*)retbuf);

    return Py_BuildValue("s", retbuf);
}

static PyMethodDef BaculaMethods[] = {
	{"bin_to_base64", clibbac_bin_to_base64, METH_VARARGS,
	 "Bacula's base64 algorythm"},
	{"hmac_md5", clibbac_hmac_md5, METH_VARARGS,
	 "Bacula's hmac_md5 algorythm"},
    {NULL, NULL, 0, NULL}        /* Sentinel */
};

PyMODINIT_FUNC
initclibbac(void)
{
    (void) Py_InitModule("clibbac", BaculaMethods);
}

int
main(int argc, char *argv[])
{
    /* Pass argv[0] to the Python interpreter */
    Py_SetProgramName(argv[0]);

    /* Initialize the Python interpreter.  Required. */
    Py_Initialize();

    /* Add a static module */
    initclibbac();
}
