/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.util;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.dataretrieval.Data;
import org.apache.axis2.dataretrieval.DataRetrievalException;
import org.apache.axis2.dataretrieval.DataRetrievalRequest;
import org.apache.axis2.description.AxisService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.PolicyRegistry;

public class PolicyLocator
implements PolicyRegistry {
    private static final Log logger = LogFactory.getLog(PolicyLocator.class);
    private AxisService service;

    public PolicyLocator(AxisService service) {
        this.service = service;
    }

    public Policy lookup(String identifier) {
        Policy policy = this.service.lookupPolicy(identifier);
        if (policy == null) {
            try {
                OMElement element;
                MessageContext msgContext = new MessageContext();
                msgContext.setAxisService(this.service);
                DataRetrievalRequest request = new DataRetrievalRequest();
                request.putDialect("http://schemas.xmlsoap.org/ws/2004/09/policy");
                request.putIdentifier(identifier);
                Data[] data = this.service.getData(request, msgContext);
                if (data.length != 0 && (element = (OMElement)data[0].getData()) != null) {
                    return PolicyEngine.getPolicy((OMElement)element);
                }
            }
            catch (DataRetrievalException ex) {
                logger.error((Object)("" + ex));
            }
            catch (AxisFault ex) {
                logger.error((Object)("" + ex));
            }
        }
        return policy;
    }

    public void register(String identifier, Policy policy) {
        throw new UnsupportedOperationException();
    }

    public void remove(String identifier) {
        throw new UnsupportedOperationException();
    }
}

