/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.intercept.AbstractSecurityInterceptor;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class WebInvocationPrivilegeEvaluator
implements InitializingBean {
    protected static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$intercept$web$WebInvocationPrivilegeEvaluator == null ? (class$org$acegisecurity$intercept$web$WebInvocationPrivilegeEvaluator = WebInvocationPrivilegeEvaluator.class$("org.acegisecurity.intercept.web.WebInvocationPrivilegeEvaluator")) : class$org$acegisecurity$intercept$web$WebInvocationPrivilegeEvaluator));
    private AbstractSecurityInterceptor securityInterceptor;
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$WebInvocationPrivilegeEvaluator;
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$FilterInvocation;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.securityInterceptor, (String)"SecurityInterceptor required");
    }

    public boolean isAllowed(FilterInvocation fi, Authentication authentication) {
        Assert.notNull((Object)fi, (String)"FilterInvocation required");
        ConfigAttributeDefinition attrs = this.securityInterceptor.obtainObjectDefinitionSource().getAttributes(fi);
        if (attrs == null) {
            return !this.securityInterceptor.isRejectPublicInvocations();
        }
        if (authentication == null || authentication.getAuthorities() == null || authentication.getAuthorities().length == 0) {
            return false;
        }
        try {
            this.securityInterceptor.getAccessDecisionManager().decide(authentication, fi, attrs);
        }
        catch (AccessDeniedException unauthorized) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(fi.toString() + " denied for " + authentication.toString()), (Throwable)((Object)unauthorized));
            }
            return false;
        }
        return true;
    }

    public void setSecurityInterceptor(AbstractSecurityInterceptor securityInterceptor) {
        Assert.notNull((Object)securityInterceptor, (String)"AbstractSecurityInterceptor cannot be null");
        Assert.isTrue((boolean)(class$org$acegisecurity$intercept$web$FilterInvocation == null ? (class$org$acegisecurity$intercept$web$FilterInvocation = WebInvocationPrivilegeEvaluator.class$("org.acegisecurity.intercept.web.FilterInvocation")) : class$org$acegisecurity$intercept$web$FilterInvocation).equals(securityInterceptor.getSecureObjectClass()), (String)"AbstractSecurityInterceptor does not support FilterInvocations");
        Assert.notNull((Object)securityInterceptor.getAccessDecisionManager(), (String)"AbstractSecurityInterceptor must provide a non-null AccessDecisionManager");
        this.securityInterceptor = securityInterceptor;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

