#!/usr/bin/env python

# get client properties for bacula

import subprocess
import json
from pprint import pprint

opsi={
    'server': "https://degdepot2.joergs:4447/rpc",
    'username': "joergs",
    'password': "linuxlinux",
    }

# "-d"
opsiCallPrefix=[ "opsi-admin",  "-a", opsi['server'], "-u", opsi['username'], "-p", opsi['password'] ]

opsiCallClientsWithBacula=[ "method", "productOnClient_getObjects", "[]", '{"productId":"bacula", "installationStatus": "installed"}']

opsiCallClientBaculaProperties=[ "method", "getProductProperties_hash", "bacula" ]

try:
    clientsWithBacula=json.loads( subprocess.check_output( opsiCallPrefix + opsiCallClientsWithBacula ) )
except subprocess.CalledProcessError:
    print "failed"
    exit( 1 )

pprint( clientsWithBacula )
        
for client in clientsWithBacula:
    print client['clientId']
    
    try:
        clientBaculaProperties=json.loads( subprocess.check_output( opsiCallPrefix + opsiCallClientBaculaProperties + [ client['clientId'] ] ) )
    except subprocess.CalledProcessError:
        print "failed"
        exit( 1 )
        
    pprint( clientBaculaProperties )
