#!/bin/bash

SOURCE_OPENSUSE="10.7.102.0::pub/opensuse/"

REPOS="distribution/11.2/repo update/11.2 distribution/12.1/repo update/12.1
repositories/Application:/Geo/openSUSE_11.2
repositories/Application:/Geo/openSUSE_12.1
repositories/LibreOffice:/Stable/openSUSE_12.1
repositories/Virtualization:/VMware/SLE_11_SP1
repositories/driver:/wireless/12.1-update/
repositories/home:/dassit
repositories/home:/dassit:/systemsmanagement:/puppet
repositories/home:/steffens:/SmartClient:/client
repositories/home:/steffens:/SmartClient:/server
repositories/home:/steffens:/lvermgeo:/client
repositories/home:/steffens:/lvermgeo:/server
"
# Folgender Eintrag aus der Variable REPOS entfernt, da auf dem BuildServer geloescht, 28.03.2012 Pruem
#repositories/home:/steffens:/branches:/openSUSE:/11.2:/Update

#
# disabled repos:
#
# nicht mehr verfügbar
#   repositories/LibreOffice:/Stable/openSUSE_11.2
# enthält derzeit keine Pakete
#   repositories/home:/steffens:/branches:/openSUSE:/11.2

RSYNC_DELETE="--delete"

#RSYNC_OPTS="-v -rlLptx --safe-links --stats \
#        --exclude=*.src.rpm --exclude=*.nosrc.rpm --exclude=*.spm \
#        --exclude=*.patch.rpm"

RSYNC_OPTS="-v -rlLptx --safe-links --stats"

DEST="/anlagen/vmlxlamp/repo/download.opensuse.org"

rsync_if_exists()
{
	src=$1
	dest=$2

	rsync -q $src || return 1
	echo rsync-quelle $src gefunden.
	[ -d "$dest" ] || return 2
	rsync $RSYNC_OPTS $RSYNC_DELETE $src ./$dest
}

# ---------------- mirror openSUSE repositories ------------------------
FAILED_REPOS=""
SUCCESSFUL=""

cd $DEST

for DIR in $REPOS 
do
  SOURCE_DIR=${SOURCE_OPENSUSE}/${DIR}/.
  DEST_DIR=${DEST}/${DIR}/.
  mkdir -p ${DEST_DIR}
  rsync_if_exists  "${SOURCE_OPENSUSE}$DIR/" "$DIR"
  case $? in
	1) 	echo Distribution $DIR nicht gefunden
		FAILED_REPOS="$FAILED_REPOS $DIR"
		;;
	2)	echo Zielverzeichnis $(pwd)/$DIR nicht vorhanden
		FAILED_REPOS="$FAILED_REPOS $DIR"
		;;
	0)
		SUCCESSFUL="$SUCCESSFUL $DIR"
		;;
	*)
		echo Fehler $?
		FAILED_REPOS="$FAILED_REPOS $DIR"
		;;
  esac
done

/usr/local/sbin/mirror-report-errors.sh mirror-osb "$SUCCESSFUL" "$FAILED_REPOS"

# adapt repository sources
for i in `find $DEST/repositories -name "*.repo" -a ! -name "vermkv-*.repo"`; do
	basename=`basename $i`
	dirname=`dirname $i`
        sed "s|http://|http://install.vermkv/freigabe/|" $i > $dirname/vermkv-$basename 
done

