#!/usr/bin/env perl

use warnings;
use strict;

use lib "/usr/lib/obs/server";
#use BSConfiguration;
#use BSRPC;
use BSNotify;
use Data::Dumper;

#
# run this 
# as user
# obsrun
# in directory
# /usr/lib/obs/server
# 

sub notify {
  my ($type, $p) = @_;
  # strip
  $p = { map {$_ => $p->{$_}} grep {defined($p->{$_}) && !ref($p->{$_})} sort keys %{$p || {}} };
  if (1) { 
	BSNotify::notify_plugins($type, $p);
  } else {
    # always route over to the src server
    print "srcserver: ", $BSConfig::srcserver, "\n";
    my $param = {
      'uri' => "$BSConfig::srcserver/notify/$type",
      'request' => 'POST',
      'headers' => [ 'Content-Type: application/x-www-form-urlencoded' ],
      'timeout' => 60,
    };
    my @args = map {"$_=$p->{$_}"} sort keys %$p;
    print Dumper( @args );
    eval {
      BSRPC::rpc($param, undef, @args);
    };
    warn($@) if $@;
  }
}

#notify( 'MY_TYPE', { project => 'myprj' , 'repo' => 'myrepo' } );
#notify( 'REPO_PUBLISHED', { 'project' => 'internal:master' , 'repository' => 'win_cross' } );
#notify( 'BUILD_SUCCESS', { 'project' => 'bareos:master', 'package' => 'bareos-docs', 'repository' => 'Debian_8.0', 'arch' => 'x86_64' } );
notify( 'BUILD_SUCCESS', { 'project' => 'internal:master', 'package' => 'winbareos-opsi', 'repository' => 'win_cross', 'arch' => 'x86_64' } );
