
#!/bin/bash
# Remote build script (iboernig@suse.de)
# $Id: build.sh 679 2004-08-10 14:05:36Z joergs $
#
# Kurze Featuritis:
# - build.sh sollte im Pfad liegen. 
#	Ein Link von ~/bin/build.sh ist eine gute Wahl ;)
# - ohne Parameter aufgerufen, 
#   erzeugt build.sh mit Hilfe des Makefiles in aktuellen Verzeichnis
#   ein tar-Archiv, bertr�t dieses nach Oldwotan und baut es dort
# - mit Parameter geht das Skript davon aus, 
#	dass der Parameter ein SRPM Paket ist.
#	Dieses wird nach oldwotan kopiert, dort entpackt und dann gebaut.
# - Dazu muss ein ssh-pubkey in oldwotans /root/.ssh/authorized_keys gelegt 
#   werden (build.sh verwendet ssh)
# Wichtige Einstellungen:
# - Standardm�ig baut build.sh mit --clean, wenns schnell gehen soll, die 
#   Umgebungsvariable BUILD_MODE="--no-init" exportieren
# - BUILD_DIST ist standard sles7-i386, kann auch durch entsprechenden Export
#   berschrieben werden.
# - die fertigen Pakete werden nach DEST_DIR (kann durch env gesetzt werden) 
#   in die vorgegebene Hierarchie (src, i386/sles/7) auf den lokalen Rechner 
#   kopiert. Vorgabe ist /tmp/smartclient_build

CONFIG_FILE=/usr/local/etc/build
BUILD_CMD=build
#SSH_VERSION="1"
#BUILDHOST="oldwotan"
#FQBUILDHOST="$BUILDHOST.suse.de"
#BUILDTEMP=abuildtmp
BUILDUSER=$USER
BUILDTEMP=/tmp/abuildtmp/$BUILDUSER

BUILDSCRIPT=$BUILDTEMP/buildscript.$$

[ -z "$BUILD_MODE" ] && BUILD_MODE="--verify"
[ -z "$BUILD_DIST" ] && BUILD_DIST="sles8-i386+update"
[ -z "$BUILD_ROOT" ] && BUILD_ROOT="/var/tmp/buildsystem.$USER.$BUILD_DIST"
[ -z "$BUILD_PREPARE_SPEC" ] && BUILD_PREPARE_SPEC="no"

[ -z $DEST_DIR ] && DEST_DIR="/tmp/build.$BUILDUSER"

if [ -r $CONFIG_FILE ]; then
	source $CONFIG_FILE
	MOD_BUILD_DIST=`echo $BUILD_DIST | sed "s/[-+.]/_/g"`
	#echo MOD_BUILD_DIST: $MOD_BUILD_DIST
	#RPMS_PATHS=$[BUILD_RPMS_$MOD_BUILD_DIST]
	#echo RPMS_PATHS: $RPM_PATHS
	#if [ -n "$[BUILD_RPMS_$MOD_BUILD_DIST]" ]; then
	#	BUILD_RPMS=$[BUILD_RPMS_$MOD_BUILD_DIST]
	#fi
	#echo OUTPUT: $[BUILD_RPMS_$MOD_BUILD_DIST]
	#:$BUILD_RPMS
	case "$BUILD_DIST" in
		"9.0-i386")	
			BUILD_RPMS_TEST=$BUILD_RPMS_9_0_i386 ;;
		"sles8-i386")	
			BUILD_RPMS_TEST=$BUILD_RPMS_sles8_i386 ;;
		"sles8-i386+update")	
			BUILD_RPMS_TEST=$BUILD_RPMS_sles8_i386_update ;;
		"9.1-i386")	
			BUILD_RPMS_TEST=$BUILD_RPMS_9_1_i386 ;;
	esac
	if [ "$BUILD_RPMS_TEST" ]; then
		if [ "$BUILD_RPMS" ]; then
			BUILD_RPMS=$BUILD_RPMS:$BUILD_RPMS_TEST
		else
			BUILD_RPMS=$BUILD_RPMS_TEST
		fi
	fi
fi

echo BUILD_RPMS: $BUILD_RPMS

ERROR=0

# Hier gehts los:

if [ -z "$1" ]; then
	# without parameter, we are in source directory
	test -e Makefile && make
	SPECFILE=$(ls *.spec | awk '{print $1}')
	TARFILE=$(ls  *.tar.[gb]z*| awk '{print $1}')
	PACKAGE=$(awk '/^Name:/ {print $2}' <$SPECFILE)
	VERSION=$(awk '/^Version:/ {print $2}' <$SPECFILE)
	SRC_FILES="$SPECFILE $TARFILE"
else
	# parameter is src.rpm file
	PACKAGE=`echo $1 | sed 's/-[0-9]*\..*.src.rpm//'`
	VERSION=`echo $1 | sed 's/.*-\([0-9]*\..*\)-.*.src.rpm/\1/'`
	SRC_FILES="$1"
fi

echo $PACKAGE $VERSION $BUILD_DIST $BUILD_MODE

# Cleaning up and install tempdir
#ssh -${SSH_VERSION} ${FQBUILDHOST} "\
	rm -rf ${BUILDTEMP}/src/${PACKAGE}; \
	mkdir -p ${BUILDTEMP}/src/${PACKAGE} ${BUILDTEMP}/${BUILD_DIST};

#scp -oProtocol=$SSH_VERSION $SRC_FILES ${FQBUILDHOST}:${BUILDTEMP}/src/${PACKAGE}
cp -a $SRC_FILES ${BUILDTEMP}/src/${PACKAGE}

if [ "$1" ]; then
	# extract RPM in a tempoary directory
	#ssh -${SSH_VERSION} ${FQBUILDHOST} "\
		cd ${BUILDTEMP}/src/${PACKAGE}; rpm2cpio $1 | cpio -i		
fi

# create buildscript

cat > $BUILDSCRIPT <<EOF
#!/bin/bash
# local buildscript
#. /work/src/bin/.profile
export BUILD_ROOT=$BUILD_ROOT
export BUILD_DIST=$BUILD_DIST
export BUILD_RPMS=${BUILDTEMP}/${BUILD_DIST}:$BUILD_RPMS
export BUILD_PREPARE_SPEC=$BUILD_PREPARE_SPEC

cd ${BUILDTEMP}/src/${PACKAGE}
#build $BUILD_MODE --prefer-rpms ${BUILDTEMP}/${BUILD_DIST}
#build $BUILD_MODE
$BUILD_CMD $BUILD_MODE
EOF
chmod a+x $BUILDSCRIPT

#cat /tmp/tmpscript.$$

#scp -oProtocol=$SSH_VERSION /tmp/tmpscript.$$ ${FQBUILDHOST}:${BUILDTEMP}/src/${PACKAGE}/buildscript
#rm /tmp/tmpscript.$$

# build and file rpms
#ssh -oProtocol=$SSH_VERSION root@${FQBUILDHOST} \
#	. ~$BUILDUSER/${BUILDTEMP}/src/${PACKAGE}/buildscript

sudo su -c $BUILDSCRIPT
rm -f $BUILDSCRIPT

#ssh -oProtocol=$SSH_VERSION ${FQBUILDHOST} \
	rm -f ${BUILDTEMP}/${BUILD_DIST}/${PACKAGE}-*.*.rpm
	cp -a ${BUILD_ROOT}/usr/src/packages/RPMS/*/${PACKAGE}-${VERSION}-*.*.rpm ${BUILDTEMP}/${BUILD_DIST}

mkdir -p ${DEST_DIR}/src
# delete all old versions of this package
rm -f ${DEST_DIR}/src/${PACKAGE}-*.src.rpm
#if !(scp -oProtocol=$SSH_VERSION root@${FQBUILDHOST}:${BUILD_ROOT}/usr/src/packages/SRPMS/${PACKAGE}-${VERSION}-*.src.rpm ${DEST_DIR}/src ); then 
	#ERROR=1
#fi
if !(cp -a ${BUILD_ROOT}/usr/src/packages/SRPMS/${PACKAGE}-${VERSION}-*.src.rpm ${DEST_DIR}/src 2> /dev/null); then 
	ERROR=1
fi

mkdir -p ${DEST_DIR}/${BUILD_DIST}
# delete all old versions of this package
rm -f ${DEST_DIR}/${BUILD_DIST}/${PACKAGE}-*.rpm
#if !(scp -oProtocol=$SSH_VERSION #root@${FQBUILDHOST}:${BUILD_ROOT}/usr/src/packages/RPMS/*/${PACKAGE}-${VERSION}-*.*.rpm ${DEST_DIR}/${BUILD_DIST} ); then 
#	ERROR=2
#fi
if !(cp -a ${BUILD_ROOT}/usr/src/packages/RPMS/*/${PACKAGE}-${VERSION}-*.*.rpm ${DEST_DIR}/${BUILD_DIST} ); then 
	ERROR=2
fi

if [ $ERROR -ne 0 ]; then
    echo "ERROR while building packet $PACKAGE";
	for i in `seq 5`; do
		echo -n "";
	done
else
	echo "Build of ${PACKAGE} completed!"
	echo "Packages can be found in ${DEST_DIR}"
fi

exit $ERROR
