#!/bin/bash 

# build prepare script

# $Id$

BUILDUSER=$USER
[ -z $DEST_DIR ] && DEST_DIR="/tmp/build.$BUILDUSER"
BUILDTEMP=$DEST_DIR/buildsrc/

[ -z "$BUILD_USES_SVN" ] && BUILD_USES_SVN="yes"

if [ -z "$1" ]; then
    # without parameter, we are in source directory
    SPECFILE=$(ls *.spec | awk '{print $1}')
    PACKAGE=$(sed -n -e 's/^Name:\W*//pi' <$SPECFILE)
    VERSION=$(sed -n -e 's/^Version:\W*//pi' <$SPECFILE)
elif [ -r "$1" ]; then
    # parameter is src.rpm file
    PACKAGE=`rpm -qp --qf "%{NAME}" $1`
    VERSION=`rpm -qp --qf "%{VERSION}" $1`
fi


if [ -z "$PACKAGE" ]; then
    echo "nothing to build found!"
    exit 1
fi

rm -rf ${BUILDTEMP}/src/${PACKAGE}
mkdir -p ${BUILDTEMP}/src/${PACKAGE}


if [ "$1" ]; then
    EXPECTED_DEST_RPM_FILENAME=${DEST_DIR}/${BUILD_DIST}/`echo $1 | sed 's/\.src\./.*./'`
    if [ -f $EXPECTED_DEST_RPM_FILENAME ]; then
        echo
        echo "Build of \"${PACKAGE}\" unnecessary. Current RPM already at " $EXPECTED_DEST_RPM_FILENAME
        echo
        exit 1
    else
        cp -a "$1" ${BUILDTEMP}/src/${PACKAGE}
        cd ${BUILDTEMP}/src/${PACKAGE}; rpm2cpio $1 | cpio -i
    fi
else
    cp -a $SPECFILE ${BUILDTEMP}/src/${PACKAGE}
    
    # uses Subversion (svn) to generate more information for the RPM
    if [ "$BUILD_USES_SVN" = "yes" ]; then
        echo "receiving subversion information ..."
        # set RELEASE number (last modification in this directory)
        # requires subversion (but connection to server isn't neccessary)
        SVN_BUILD_RELEASE=$(unset LANG; svn info . | sed -n 's/^Last Changed Rev: \([0-9]*\)/\1/p')
        # in case of local modification a "m" is added to the release number
        SVN_BUILD_MODIFIED=$(svn status -v | grep "^ *M" | wc -l)
        # checks if a file is commited, 
        # but update on its directory is not performed
        SVN_LAST_MODIFICATION=$(svn status -v | sed -n 's/^ *[0-9]* *\([0-9]*\) .*/\1/p' | sort -n | tail -1)
        if [ $SVN_BUILD_MODIFIED -gt 0 ]; then  
            SVN_BUILD_RELEASE=${SVN_BUILD_RELEASE}m
        elif [ $SVN_LAST_MODIFICATION -ne $SVN_BUILD_RELEASE ]; then
            SVN_BUILD_RELEASE=${SVN_BUILD_RELEASE}p
        else # check if RPM has been build already
            # TODO: this chekc is broken for OpenSUSE build service,
            #       because version is changed later on
            EXPECTED_DEST_RPM_FILENAME=${DEST_DIR}/${BUILD_DIST}/${PACKAGE}-${VERSION}-${SVN_BUILD_RELEASE}.*.rpm
            if [ -f $EXPECTED_DEST_RPM_FILENAME ]; then
                echo
                echo "Build of \"${PACKAGE}\" unnecessary. Current RPM already at " $EXPECTED_DEST_RPM_FILENAME
                echo
                exit 1
            fi
        fi
        if [ "$SVN_BUILD_RELEASE" ]; then
            # Release will be overwritten bei OpenSUSE build service,
            # therefore we add SVN_BUILD_RELEASE to Version
            VERSION_ORIG=$VERSION
            VERSION=$VERSION.$SVN_BUILD_RELEASE
            #sed "s/^Release:.*/Release: $SVN_BUILD_RELEASE/ig" $SPECFILE > ${BUILDTEMP}/src/${PACKAGE}/$SPECFILE
            #sed -r "s/^(Version:\s*\S*)/\1.$SVN_BUILD_RELEASE/ig"  $SPECFILE > ${BUILDTEMP}/src/${PACKAGE}/$SPECFILE
            sed "s/^Version:.*/Version: $VERSION/ig" $SPECFILE > ${BUILDTEMP}/src/${PACKAGE}/$SPECFILE
        fi
        echo "SVN_BUILD_RELEASE: $SVN_BUILD_RELEASE"
        
        printf "adding subversion changelog: "
        # changelog header
        DATE=`unset LANG; date +"%a %b %d %Y"`
        echo -e "* $DATE -\n" > Changes
        echo "- Subversion status:" >> Changes
        # additional infos for the Changes file (see if everything is checked in)
        svn status -v | grep -v '^? ' >> Changes
        echo >> Changes
        echo "- ChangeLog:" >> Changes
        # requires connection to the subversion server
        svn log -v . > ChangeLog.new && mv ChangeLog.new ChangeLog
        cat ChangeLog >> Changes
        
        # if there is no changelog section in the spec file,
        # also append the Changes there
        if ! grep -q -i "%changelog" $SPECFILE ; then
            # paste "Changes" into SPEC file. 
            echo "%changelog" >> ${BUILDTEMP}/src/${PACKAGE}/$SPECFILE
            # without trailing *, except for the initial
            echo -n "*" >> ${BUILDTEMP}/src/${PACKAGE}/$SPECFILE
            cat Changes | sed 's/\(^[\*]\+\)//g' >> ${BUILDTEMP}/src/${PACKAGE}/$SPECFILE
        fi
        printf "done\n"
    fi
    # just make sure, that the Changes file exist
    touch Changes
    
    # if "SOURCES" file exist, create tar file on the fly
    if [ -r "SOURCES" ]; then
        # create a tar file from the sources
        tar cvjf ${BUILDTEMP}/src/${PACKAGE}/$PACKAGE-$VERSION.tar.bz2 --files-from SOURCES --exclude .svn --exclude "*~"
    
    elif [ -r "SPECSOURCES" ]; then
        # SPECSOURCES has to list the files 
        # that are referenced in the .spec file
        # these files are copied to the build environment
        cp -av `cat SPECSOURCES` ${BUILDTEMP}/src/${PACKAGE}
    
    else 
        # legacy method: 
        # call the existing Makefile 
        # to generate a tar file    
        test -e Makefile && make
        TARFILE=$(ls  *.tar.[gb]z*| awk '{print $1}')
        cp -av $TARFILE ${BUILDTEMP}/src/${PACKAGE}
    fi
fi
