/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.context.externalize;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import org.apache.axis2.java.security.AccessController;

public class ObjectInputStreamWithCL
extends ObjectInputStream {
    private static final HashMap primClasses = new HashMap(8, 1.0f);
    protected ClassResolver resolver;
    protected ClassLoader classloader;
    protected String name;
    PrivilegedExceptionAction loadAction = new PrivilegedExceptionAction(){

        public Object run() throws Exception {
            try {
                Class clazz = null;
                if (ObjectInputStreamWithCL.this.resolver != null) {
                    clazz = ObjectInputStreamWithCL.this.resolver.resolveClass(ObjectInputStreamWithCL.this.name);
                }
                if (clazz == null) {
                    clazz = ObjectInputStreamWithCL.this.loadClass(ObjectInputStreamWithCL.this.name, ObjectInputStreamWithCL.this.classloader);
                }
                return clazz;
            }
            catch (ClassNotFoundException cnf) {
                Class c = (Class)primClasses.get(ObjectInputStreamWithCL.this.name);
                if (c != null) {
                    return c;
                }
                throw cnf;
            }
        }
    };
    private Class proxyClass;
    PrivilegedAction proxyClassLoaderAction = new PrivilegedAction(){

        public Object run() {
            return ObjectInputStreamWithCL.this.proxyClass.getClassLoader();
        }
    };

    public ObjectInputStreamWithCL(InputStream is) throws IOException {
        super(is);
        this.classloader = (ClassLoader)java.security.AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public ObjectInputStreamWithCL(InputStream is, ClassLoader cl) throws IOException {
        super(is);
        this.classloader = cl;
    }

    public ObjectInputStreamWithCL(InputStream is, ClassResolver r) throws IOException {
        super(is);
        this.resolver = r;
    }

    protected Class resolveClass(ObjectStreamClass objStrmClass) throws ClassNotFoundException {
        return this.resolveClass(objStrmClass.getName());
    }

    private Class resolveClass(String name) throws ClassNotFoundException {
        try {
            this.name = name;
            return (Class)java.security.AccessController.doPrivileged(this.loadAction);
        }
        catch (PrivilegedActionException pae) {
            Exception wrapped = pae.getException();
            if (wrapped instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)wrapped;
            }
            throw new ClassNotFoundException(name);
        }
    }

    private Class loadClass(final String name, final ClassLoader loader) throws ClassNotFoundException {
        try {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return Class.forName(name, true, loader);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (ClassNotFoundException)e.getException();
            }
        }
        catch (ClassNotFoundException cnf) {
            try {
                return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        return Class.forName(name);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw (ClassNotFoundException)e.getException();
            }
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws ClassNotFoundException {
        if (interfaces.length == 0) {
            throw new ClassNotFoundException("zero-length interfaces array");
        }
        Class nonPublicClass = null;
        final Class[] classes = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            classes[i] = this.resolveClass(interfaces[i]);
            if ((classes[i].getModifiers() & 1) != 0) continue;
            if (nonPublicClass != null) {
                throw new IllegalAccessError(nonPublicClass + " and " + classes[i] + " both declared non-public");
            }
            nonPublicClass = classes[i];
        }
        this.proxyClass = nonPublicClass != null ? nonPublicClass : classes[0];
        final ClassLoader loader = (ClassLoader)java.security.AccessController.doPrivileged(this.proxyClassLoaderAction);
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Proxy.getProxyClass(loader, classes);
                }
            });
        }
        catch (IllegalArgumentException ex) {
            throw new ClassNotFoundException(ex.getMessage(), ex);
        }
    }

    static {
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
    }

    public static interface ClassResolver {
        public Class resolveClass(String var1);
    }
}

