/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.corba.receivers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.axis2.corba.exceptions.CorbaInvocationException;
import org.apache.axis2.corba.idl.types.DataType;
import org.apache.axis2.corba.idl.types.ExceptionType;
import org.apache.axis2.corba.idl.types.Interface;
import org.apache.axis2.corba.idl.types.Member;
import org.apache.axis2.corba.idl.types.Operation;
import org.apache.axis2.corba.idl.values.ExceptionValue;
import org.apache.axis2.corba.receivers.CorbaUtil;
import org.apache.axis2.corba.receivers.Invoker;
import org.omg.CORBA.Any;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.Object;
import org.omg.CORBA.Request;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UnknownUserException;

public class CorbaInvoker
implements Invoker {
    private Operation operation;
    private Interface intf;
    private Object object;
    private java.lang.Object[] parameters;
    private List parameterTypeList = new ArrayList();
    private List returnedParams;

    protected CorbaInvoker(Operation operation, Interface intf, Object object) {
        this.operation = operation;
        this.intf = intf;
        this.object = object;
        List params = operation.getParams();
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                Member member = (Member)params.get(i);
                this.parameterTypeList.add(member);
            }
        }
    }

    public java.lang.Object invoke() throws CorbaInvocationException {
        List exceptions;
        DataType returnType;
        String mode;
        Request request = this.object._request(this.operation.getName());
        Any arg = null;
        ArrayList<Any> memArgs = new ArrayList<Any>();
        if (this.parameters != null) {
            LinkedList<java.lang.Object> patamList = new LinkedList<java.lang.Object>(Arrays.asList(this.parameters));
            Iterator paramsIter = patamList.iterator();
            for (int i = 0; i < this.parameterTypeList.size(); ++i) {
                Member member = (Member)this.parameterTypeList.get(i);
                DataType type = member.getDataType();
                java.lang.Object value = null;
                mode = member.getMode();
                if (mode.equals("in")) {
                    arg = request.add_in_arg();
                    value = paramsIter.next();
                } else if (mode.equals("inout")) {
                    arg = request.add_inout_arg();
                    value = paramsIter.next();
                } else if (mode.equals("out")) {
                    arg = request.add_out_arg();
                    value = CorbaUtil.getEmptyValue(type);
                }
                memArgs.add(arg);
                CorbaUtil.insertValue(arg, type, value);
            }
        }
        if ((returnType = this.operation.getReturnType()) != null) {
            TypeCode typeCode = returnType.getTypeCode();
            request.set_return_type(typeCode);
        }
        if ((exceptions = this.operation.getRaises()) != null && !exceptions.isEmpty()) {
            ExceptionList exceptionList = request.exceptions();
            for (int i = 0; i < exceptions.size(); ++i) {
                ExceptionType exType = (ExceptionType)exceptions.get(i);
                exceptionList.add(exType.getTypeCode());
            }
        }
        request.invoke();
        java.lang.Object returnValue = null;
        Exception exception = request.env().exception();
        if (exception == null) {
            if (returnType != null) {
                Any returned = request.return_value();
                returnValue = CorbaUtil.extractValue(returnType, returned);
            }
            this.returnedParams = new ArrayList();
            for (int i = 0; i < this.parameterTypeList.size(); ++i) {
                Member member = (Member)this.parameterTypeList.get(i);
                mode = member.getMode();
                if (!mode.equals("inout") && !mode.equals("out")) continue;
                this.returnedParams.add(CorbaUtil.extractValue(member.getDataType(), (Any)memArgs.get(i)));
            }
        } else if (exception instanceof UnknownUserException) {
            UnknownUserException userException = (UnknownUserException)exception;
            TypeCode exTypeCode = userException.except.type();
            ExceptionType exceptionType = null;
            if (exceptions != null && !exceptions.isEmpty()) {
                for (int i = 0; i < exceptions.size(); ++i) {
                    ExceptionType exType = (ExceptionType)exceptions.get(i);
                    if (!exTypeCode.equal(exType.getTypeCode())) continue;
                    exceptionType = exType;
                    break;
                }
            }
            if (exceptionType == null) {
                throw new CorbaInvocationException(exception);
            }
            ExceptionValue exceptionValue = (ExceptionValue)CorbaUtil.extractValue(exceptionType, userException.except);
            if (exceptionValue != null) {
                throw exceptionValue.getException();
            }
        } else {
            throw new CorbaInvocationException(exception);
        }
        return returnValue;
    }

    public void setParameters(java.lang.Object[] parameters) {
        this.parameters = parameters;
    }

    public String getInterfaceName() {
        return this.intf.getName();
    }

    public String getOperationName() {
        return this.operation.getName();
    }

    public DataType getReturnType() {
        return this.operation.getReturnType();
    }

    public java.lang.Object[] getOutParameterValuess() {
        if (this.returnedParams == null) {
            return null;
        }
        return this.returnedParams.toArray();
    }

    public Member[] getParameterMembers() {
        Member[] membersArray = new Member[this.parameterTypeList.size()];
        for (int i = 0; i < this.parameterTypeList.size(); ++i) {
            membersArray[i] = (Member)this.parameterTypeList.get(i);
        }
        return membersArray;
    }
}

