/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AbstractAgent {
    protected static final String DEFAULT_INDEX_JSP = "index.jsp";
    private static final String METHOD_PREFIX = "process";
    private static final Log log = LogFactory.getLog(AbstractAgent.class);
    protected transient Map operationCache = new HashMap();
    protected transient ConfigurationContext configContext;

    public AbstractAgent(ConfigurationContext aConfigContext) {
        this.configContext = aConfigContext;
        this.preloadMethods();
    }

    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String requestURI = httpServletRequest.getRequestURI();
        int i = requestURI.lastIndexOf(47);
        if (i < 0) {
            this.processUnknown(httpServletRequest, httpServletResponse);
            return;
        }
        if (i == requestURI.length() - 1) {
            this.processIndex(httpServletRequest, httpServletResponse);
            return;
        }
        String operation = requestURI.substring(i + 1);
        Method method = (Method)this.operationCache.get(operation.toLowerCase());
        if (method != null) {
            try {
                method.invoke((Object)this, httpServletRequest, httpServletResponse);
            }
            catch (Exception e) {
                log.warn((Object)("Error dispatching request " + requestURI), (Throwable)e);
                httpServletResponse.setStatus(500);
            }
        } else {
            this.processUnknown(httpServletRequest, httpServletResponse);
        }
    }

    protected void processIndex(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.renderView(DEFAULT_INDEX_JSP, httpServletRequest, httpServletResponse);
    }

    protected void processUnknown(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        httpServletResponse.sendError(404, httpServletRequest.getRequestURI());
    }

    protected void renderView(String jspName, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        httpServletResponse.setContentType("text/html");
        try {
            httpServletRequest.getRequestDispatcher("/axis2-web/" + jspName).include((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        catch (Throwable t) {
            log.info((Object)("Old Servlet API :" + t));
        }
    }

    private void preloadMethods() {
        for (Class<?> clazz = this.getClass(); clazz != null && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            this.examineMethods(clazz.getDeclaredMethods());
        }
    }

    private void examineMethods(Method[] aDeclaredMethods) {
        for (int i = 0; i < aDeclaredMethods.length; ++i) {
            String key;
            Method method = aDeclaredMethods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!Modifier.isProtected(method.getModifiers()) && !Modifier.isPublic(method.getModifiers()) || !method.getName().startsWith(METHOD_PREFIX) || parameterTypes.length != 2 || !parameterTypes[0].equals(HttpServletRequest.class) || !parameterTypes[1].equals(HttpServletResponse.class) || this.operationCache.containsKey(key = method.getName().substring(METHOD_PREFIX.length()).toLowerCase())) continue;
            this.operationCache.put(key, method);
        }
    }

    protected void populateSessionInformation(HttpServletRequest req) {
        HashMap services = this.configContext.getAxisConfiguration().getServices();
        try {
            req.getSession().setAttribute("servicemap", (Object)services);
            req.getSession().setAttribute("servicePath", (Object)this.configContext.getServicePath());
        }
        catch (Throwable t) {
            log.info((Object)("Old Servlet API :" + t));
        }
    }
}

