/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.soapmonitor.applet;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class SOAPMonitorApplet
extends JApplet {
    private JPanel main_panel = null;
    private JTabbedPane tabbed_pane = null;
    private int port = 0;
    private Vector pages = null;

    public void init() {
        String port_str = this.getParameter("port");
        if (port_str != null) {
            this.port = Integer.parseInt(port_str);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.main_panel = new JPanel();
        this.main_panel.setBackground(Color.white);
        this.main_panel.setLayout(new BorderLayout());
        this.setContentPane(this.main_panel);
        this.tabbed_pane = new JTabbedPane(1);
        this.main_panel.add((Component)this.tabbed_pane, "Center");
        this.pages = new Vector();
        this.addPage(new SOAPMonitorPage(this.getCodeBase().getHost()));
    }

    private void addPage(SOAPMonitorPage pg) {
        this.tabbed_pane.addTab("  " + pg.getHost() + "  ", pg);
        this.pages.addElement(pg);
    }

    public void start() {
        Enumeration e = this.pages.elements();
        while (e.hasMoreElements()) {
            SOAPMonitorPage pg = (SOAPMonitorPage)e.nextElement();
            if (pg == null) continue;
            pg.start();
        }
    }

    public void stop() {
        Enumeration e = this.pages.elements();
        while (e.hasMoreElements()) {
            SOAPMonitorPage pg = (SOAPMonitorPage)e.nextElement();
            if (pg == null) continue;
            pg.stop();
        }
    }

    public void destroy() {
        this.tabbed_pane = null;
        this.main_panel = null;
    }

    class SOAPMonitorTextArea
    extends JTextArea {
        private boolean format = false;
        private String original = "";
        private String formatted = null;

        public void setText(String text) {
            this.original = text;
            this.formatted = null;
            if (this.format) {
                this.doFormat();
                super.setText(this.formatted);
            } else {
                super.setText(this.original);
            }
        }

        public void setReflowXML(boolean reflow) {
            this.format = reflow;
            if (this.format) {
                if (this.formatted == null) {
                    this.doFormat();
                }
                super.setText(this.formatted);
            } else {
                super.setText(this.original);
            }
        }

        public void doFormat() {
            int index;
            Vector<String> parts = new Vector<String>();
            char[] chars = this.original.toCharArray();
            int first = 0;
            String part = null;
            for (index = 0; index < chars.length; ++index) {
                if (chars[index] == '<') {
                    if (first < index) {
                        part = new String(chars, first, index - first);
                        if ((part = part.trim()).length() > 0) {
                            parts.addElement(part);
                        }
                    }
                    first = index;
                }
                if (chars[index] == '>') {
                    part = new String(chars, first, index - first + 1);
                    parts.addElement(part);
                    first = index + 1;
                }
                if (chars[index] != '\n' && chars[index] != '\r') continue;
                if (first < index) {
                    part = new String(chars, first, index - first);
                    if ((part = part.trim()).length() > 0) {
                        parts.addElement(part);
                    }
                }
                first = index + 1;
            }
            StringBuffer buf = new StringBuffer();
            Object[] list = parts.toArray();
            int indent = 0;
            int pad = 0;
            for (index = 0; index < list.length; ++index) {
                part = (String)list[index];
                if (buf.length() == 0) {
                    buf.append(part);
                    continue;
                }
                buf.append('\n');
                if (part.startsWith("</")) {
                    --indent;
                }
                for (pad = 0; pad < indent; ++pad) {
                    buf.append("  ");
                }
                buf.append(part);
                if (!part.startsWith("<") || part.startsWith("</") || part.endsWith("/>")) continue;
                ++indent;
                if (index + 2 >= list.length || !(part = (String)list[index + 2]).startsWith("</") || (part = (String)list[index + 1]).startsWith("<")) continue;
                buf.append(part);
                part = (String)list[index + 2];
                buf.append(part);
                index += 2;
                --indent;
            }
            this.formatted = new String(buf);
        }
    }

    class SOAPMonitorFilter
    implements ActionListener {
        private JDialog dialog = null;
        private JPanel panel = null;
        private JPanel buttons = null;
        private JButton ok_button = null;
        private JButton cancel_button = null;
        private ServiceFilterPanel include_panel = null;
        private ServiceFilterPanel exclude_panel = null;
        private JPanel status_panel = null;
        private JCheckBox status_box = null;
        private EmptyBorder empty_border = null;
        private EmptyBorder indent_border = null;
        private JPanel status_options = null;
        private ButtonGroup status_group = null;
        private JRadioButton status_active = null;
        private JRadioButton status_complete = null;
        private Vector filter_include_list = null;
        private Vector filter_exclude_list = new Vector();
        private boolean filter_active = false;
        private boolean filter_complete = false;
        private boolean ok_pressed = false;

        public SOAPMonitorFilter() {
            this.filter_exclude_list.addElement("NotificationService");
            this.filter_exclude_list.addElement("EventViewerService");
        }

        public Vector getFilterIncludeList() {
            return this.filter_include_list;
        }

        public Vector getFilterExcludeList() {
            return this.filter_exclude_list;
        }

        public boolean getFilterActive() {
            return this.filter_active;
        }

        public boolean getFilterComplete() {
            return this.filter_complete;
        }

        public void showDialog() {
            this.empty_border = new EmptyBorder(5, 5, 0, 5);
            this.indent_border = new EmptyBorder(5, 25, 5, 5);
            this.include_panel = new ServiceFilterPanel("Include messages based on target service:", this.filter_include_list);
            this.exclude_panel = new ServiceFilterPanel("Exclude messages based on target service:", this.filter_exclude_list);
            this.status_box = new JCheckBox("Filter messages based on status:");
            this.status_box.addActionListener(this);
            this.status_active = new JRadioButton("Active messages only");
            this.status_active.setSelected(true);
            this.status_active.setEnabled(false);
            this.status_complete = new JRadioButton("Complete messages only");
            this.status_complete.setEnabled(false);
            this.status_group = new ButtonGroup();
            this.status_group.add(this.status_active);
            this.status_group.add(this.status_complete);
            if (this.filter_active || this.filter_complete) {
                this.status_box.setSelected(true);
                this.status_active.setEnabled(true);
                this.status_complete.setEnabled(true);
                if (this.filter_complete) {
                    this.status_complete.setSelected(true);
                }
            }
            this.status_options = new JPanel();
            this.status_options.setLayout(new BoxLayout(this.status_options, 1));
            this.status_options.add(this.status_active);
            this.status_options.add(this.status_complete);
            this.status_options.setBorder(this.indent_border);
            this.status_panel = new JPanel();
            this.status_panel.setLayout(new BorderLayout());
            this.status_panel.add((Component)this.status_box, "North");
            this.status_panel.add((Component)this.status_options, "Center");
            this.status_panel.setBorder(this.empty_border);
            this.ok_button = new JButton("Ok");
            this.ok_button.addActionListener(this);
            this.cancel_button = new JButton("Cancel");
            this.cancel_button.addActionListener(this);
            this.buttons = new JPanel();
            this.buttons.setLayout(new FlowLayout());
            this.buttons.add(this.ok_button);
            this.buttons.add(this.cancel_button);
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.add(this.include_panel);
            this.panel.add(this.exclude_panel);
            this.panel.add(this.status_panel);
            this.panel.add(this.buttons);
            this.dialog = new JDialog();
            this.dialog.setTitle("SOAP Monitor Filter");
            this.dialog.setContentPane(this.panel);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setModal(true);
            this.dialog.pack();
            Dimension d = this.dialog.getToolkit().getScreenSize();
            this.dialog.setLocation((d.width - this.dialog.getWidth()) / 2, (d.height - this.dialog.getHeight()) / 2);
            this.ok_pressed = false;
            this.dialog.show();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.ok_button) {
                this.filter_include_list = this.include_panel.getServiceList();
                this.filter_exclude_list = this.exclude_panel.getServiceList();
                if (this.status_box.isSelected()) {
                    this.filter_active = this.status_active.isSelected();
                    this.filter_complete = this.status_complete.isSelected();
                } else {
                    this.filter_active = false;
                    this.filter_complete = false;
                }
                this.ok_pressed = true;
                this.dialog.dispose();
            }
            if (e.getSource() == this.cancel_button) {
                this.dialog.dispose();
            }
            if (e.getSource() == this.status_box) {
                this.status_active.setEnabled(this.status_box.isSelected());
                this.status_complete.setEnabled(this.status_box.isSelected());
            }
        }

        public boolean okPressed() {
            return this.ok_pressed;
        }
    }

    class ServiceFilterPanel
    extends JPanel
    implements ActionListener,
    ListSelectionListener,
    DocumentListener {
        private JCheckBox service_box = null;
        private Vector filter_list = null;
        private Vector service_data = null;
        private JList service_list = null;
        private JScrollPane service_scroll = null;
        private JButton remove_service_button = null;
        private JPanel remove_service_panel = null;
        private EmptyBorder indent_border = null;
        private EmptyBorder empty_border = new EmptyBorder(5, 5, 0, 5);
        private JPanel service_area = null;
        private JPanel add_service_area = null;
        private JTextField add_service_field = null;
        private JButton add_service_button = null;
        private JPanel add_service_panel = null;

        public ServiceFilterPanel(String text, Vector list) {
            this.indent_border = new EmptyBorder(5, 25, 5, 5);
            this.service_box = new JCheckBox(text);
            this.service_box.addActionListener(this);
            this.service_data = new Vector();
            if (list != null) {
                this.service_box.setSelected(true);
                this.service_data = (Vector)list.clone();
            }
            this.service_list = new JList(this.service_data);
            this.service_list.setBorder(new EtchedBorder());
            this.service_list.setVisibleRowCount(5);
            this.service_list.addListSelectionListener(this);
            this.service_list.setEnabled(this.service_box.isSelected());
            this.service_scroll = new JScrollPane(this.service_list);
            this.service_scroll.setBorder(new EtchedBorder());
            this.remove_service_button = new JButton("Remove");
            this.remove_service_button.addActionListener(this);
            this.remove_service_button.setEnabled(false);
            this.remove_service_panel = new JPanel();
            this.remove_service_panel.setLayout(new FlowLayout());
            this.remove_service_panel.add(this.remove_service_button);
            this.service_area = new JPanel();
            this.service_area.setLayout(new BorderLayout());
            this.service_area.add((Component)this.service_scroll, "Center");
            this.service_area.add((Component)this.remove_service_panel, "East");
            this.service_area.setBorder(this.indent_border);
            this.add_service_field = new JTextField();
            this.add_service_field.addActionListener(this);
            this.add_service_field.getDocument().addDocumentListener(this);
            this.add_service_field.setEnabled(this.service_box.isSelected());
            this.add_service_button = new JButton("Add");
            this.add_service_button.addActionListener(this);
            this.add_service_button.setEnabled(false);
            this.add_service_panel = new JPanel();
            this.add_service_panel.setLayout(new BorderLayout());
            JPanel dummy = new JPanel();
            dummy.setBorder(this.empty_border);
            this.add_service_panel.add((Component)dummy, "West");
            this.add_service_panel.add((Component)this.add_service_button, "East");
            this.add_service_area = new JPanel();
            this.add_service_area.setLayout(new BorderLayout());
            this.add_service_area.add((Component)this.add_service_field, "Center");
            this.add_service_area.add((Component)this.add_service_panel, "East");
            this.add_service_area.setBorder(this.indent_border);
            this.setLayout(new BorderLayout());
            this.add((Component)this.service_box, "North");
            this.add((Component)this.service_area, "Center");
            this.add((Component)this.add_service_area, "South");
            this.setBorder(this.empty_border);
        }

        public Vector getServiceList() {
            Vector list = null;
            if (this.service_box.isSelected()) {
                list = this.service_data;
            }
            return list;
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.service_box) {
                this.service_list.setEnabled(this.service_box.isSelected());
                this.service_list.clearSelection();
                this.remove_service_button.setEnabled(false);
                this.add_service_field.setEnabled(this.service_box.isSelected());
                this.add_service_field.setText("");
                this.add_service_button.setEnabled(false);
            }
            if (e.getSource() == this.add_service_button || e.getSource() == this.add_service_field) {
                String text = this.add_service_field.getText();
                if (text != null && text.length() > 0) {
                    this.service_data.addElement(text);
                    this.service_list.setListData(this.service_data);
                }
                this.add_service_field.setText("");
                this.add_service_field.requestFocus();
            }
            if (e.getSource() == this.remove_service_button) {
                Object[] sels = this.service_list.getSelectedValues();
                for (int i = 0; i < sels.length; ++i) {
                    this.service_data.removeElement(sels[i]);
                }
                this.service_list.setListData(this.service_data);
                this.service_list.clearSelection();
            }
        }

        public void changedUpdate(DocumentEvent e) {
            String text = this.add_service_field.getText();
            if (text != null && text.length() > 0) {
                this.add_service_button.setEnabled(true);
            } else {
                this.add_service_button.setEnabled(false);
            }
        }

        public void insertUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        public void removeUpdate(DocumentEvent e) {
            this.changedUpdate(e);
        }

        public void valueChanged(ListSelectionEvent e) {
            if (this.service_list.getSelectedIndex() == -1) {
                this.remove_service_button.setEnabled(false);
            } else {
                this.remove_service_button.setEnabled(true);
            }
        }
    }

    class SOAPMonitorTableModel
    extends AbstractTableModel {
        private final String[] column_names = new String[]{"Time", "Target Service", "Status"};
        private Vector data = new Vector();
        private Vector filter_include;
        private Vector filter_exclude;
        private boolean filter_active;
        private boolean filter_complete;
        private Vector filter_data;

        public SOAPMonitorTableModel() {
            SOAPMonitorData soap = new SOAPMonitorData(null, null, null);
            this.data.addElement(soap);
            this.filter_include = null;
            this.filter_exclude = null;
            this.filter_active = false;
            this.filter_complete = false;
            this.filter_data = null;
            this.filter_exclude = new Vector();
            this.filter_exclude.addElement("NotificationService");
            this.filter_exclude.addElement("EventViewerService");
            this.filter_data = new Vector();
            this.filter_data.addElement(soap);
        }

        public int getColumnCount() {
            return this.column_names.length;
        }

        public int getRowCount() {
            int count = this.data.size();
            if (this.filter_data != null) {
                count = this.filter_data.size();
            }
            return count;
        }

        public String getColumnName(int col) {
            return this.column_names[col];
        }

        public Object getValueAt(int row, int col) {
            String value = null;
            SOAPMonitorData soap = (SOAPMonitorData)this.data.elementAt(row);
            if (this.filter_data != null) {
                soap = (SOAPMonitorData)this.filter_data.elementAt(row);
            }
            switch (col) {
                case 0: {
                    value = soap.getTime();
                    break;
                }
                case 1: {
                    value = soap.getTargetService();
                    break;
                }
                case 2: {
                    value = soap.getStatus();
                }
            }
            return value;
        }

        public boolean filterMatch(SOAPMonitorData soap) {
            String service;
            Enumeration e;
            boolean match = true;
            if (this.filter_include != null) {
                e = this.filter_include.elements();
                match = false;
                while (e.hasMoreElements() && !match) {
                    service = (String)e.nextElement();
                    if (!service.equals(soap.getTargetService())) continue;
                    match = true;
                }
            }
            if (this.filter_exclude != null) {
                e = this.filter_exclude.elements();
                while (e.hasMoreElements() && match) {
                    service = (String)e.nextElement();
                    if (!service.equals(soap.getTargetService())) continue;
                    match = false;
                }
            }
            if (this.filter_active && soap.getSOAPResponse() != null) {
                match = false;
            }
            if (this.filter_complete && soap.getSOAPResponse() == null) {
                match = false;
            }
            if (soap.getId() == null) {
                match = true;
            }
            return match;
        }

        public void addData(SOAPMonitorData soap) {
            int row = this.data.size();
            this.data.addElement(soap);
            if (this.filter_data != null) {
                if (this.filterMatch(soap)) {
                    row = this.filter_data.size();
                    this.filter_data.addElement(soap);
                    this.fireTableRowsInserted(row, row);
                }
            } else {
                this.fireTableRowsInserted(row, row);
            }
        }

        public SOAPMonitorData findData(Long id) {
            SOAPMonitorData soap = null;
            for (int row = this.data.size(); row > 0 && soap == null; --row) {
                soap = (SOAPMonitorData)this.data.elementAt(row - 1);
                if (soap.getId().longValue() == id.longValue()) continue;
                soap = null;
            }
            return soap;
        }

        public int findRow(SOAPMonitorData soap) {
            int row = -1;
            row = this.filter_data != null ? this.filter_data.indexOf(soap) : this.data.indexOf(soap);
            return row;
        }

        public void clearAll() {
            int last_row = this.data.size() - 1;
            if (last_row > 0) {
                this.data.removeAllElements();
                SOAPMonitorData soap = new SOAPMonitorData(null, null, null);
                this.data.addElement(soap);
                if (this.filter_data != null) {
                    this.filter_data.removeAllElements();
                    this.filter_data.addElement(soap);
                }
                this.fireTableDataChanged();
            }
        }

        public void removeRow(int row) {
            SOAPMonitorData soap = null;
            if (this.filter_data == null) {
                soap = (SOAPMonitorData)this.data.elementAt(row);
                this.data.remove(soap);
            } else {
                soap = (SOAPMonitorData)this.filter_data.elementAt(row);
                this.filter_data.remove(soap);
                this.data.remove(soap);
            }
            this.fireTableRowsDeleted(row, row);
        }

        public void setFilter(SOAPMonitorFilter filter) {
            this.filter_include = filter.getFilterIncludeList();
            this.filter_exclude = filter.getFilterExcludeList();
            this.filter_active = filter.getFilterActive();
            this.filter_complete = filter.getFilterComplete();
            this.applyFilter();
        }

        public void applyFilter() {
            this.filter_data = null;
            if (this.filter_include != null || this.filter_exclude != null || this.filter_active || this.filter_complete) {
                this.filter_data = new Vector();
                Enumeration e = this.data.elements();
                while (e.hasMoreElements()) {
                    SOAPMonitorData soap = (SOAPMonitorData)e.nextElement();
                    if (!this.filterMatch(soap)) continue;
                    this.filter_data.addElement(soap);
                }
            }
            this.fireTableDataChanged();
        }

        public SOAPMonitorData getData(int row) {
            SOAPMonitorData soap = null;
            soap = this.filter_data == null ? (SOAPMonitorData)this.data.elementAt(row) : (SOAPMonitorData)this.filter_data.elementAt(row);
            return soap;
        }

        public void updateData(SOAPMonitorData soap) {
            if (this.filter_data == null) {
                int row = this.data.indexOf(soap);
                if (row != -1) {
                    this.fireTableRowsUpdated(row, row);
                }
            } else {
                int row = this.filter_data.indexOf(soap);
                if (row == -1) {
                    if (this.filterMatch(soap)) {
                        int index = -1;
                        for (row = this.data.indexOf(soap) + 1; row < this.data.size() && index == -1; ++row) {
                            index = this.filter_data.indexOf(this.data.elementAt(row));
                            if (index == -1) continue;
                            this.filter_data.add(index, soap);
                        }
                        if (index == -1) {
                            index = this.filter_data.size();
                            this.filter_data.addElement(soap);
                        }
                        this.fireTableRowsInserted(index, index);
                    }
                } else if (this.filterMatch(soap)) {
                    this.fireTableRowsUpdated(row, row);
                } else {
                    this.filter_data.remove(soap);
                    this.fireTableRowsDeleted(row, row);
                }
            }
        }
    }

    class SOAPMonitorData {
        private Long id;
        private String time;
        private String target;
        private String soap_request;
        private String soap_response;

        public SOAPMonitorData(Long id, String target, String soap_request) {
            this.id = id;
            if (id == null) {
                this.time = "Most Recent";
                this.target = "---";
                this.soap_request = null;
                this.soap_response = null;
            } else {
                this.time = DateFormat.getTimeInstance().format(new Date());
                this.target = target;
                this.soap_request = soap_request;
                this.soap_response = null;
            }
        }

        public Long getId() {
            return this.id;
        }

        public String getTime() {
            return this.time;
        }

        public String getTargetService() {
            return this.target;
        }

        public String getStatus() {
            String status = "---";
            if (this.id != null) {
                status = "Complete";
                if (this.soap_response == null) {
                    status = "Active";
                }
            }
            return status;
        }

        public String getSOAPRequest() {
            return this.soap_request;
        }

        public void setSOAPResponse(String response) {
            this.soap_response = response;
        }

        public String getSOAPResponse() {
            return this.soap_response;
        }
    }

    class SOAPMonitorPage
    extends JPanel
    implements Runnable,
    ListSelectionListener,
    ActionListener {
        private final String STATUS_ACTIVE = "The SOAP Monitor is started.";
        private final String STATUS_STOPPED = "The SOAP Monitor is stopped.";
        private final String STATUS_CLOSED = "The server communication has been terminated.";
        private final String STATUS_NOCONNECT = "The SOAP Monitor is unable to communcate with the server.";
        private String host = null;
        private Socket socket = null;
        private ObjectInputStream in = null;
        private ObjectOutputStream out = null;
        private SOAPMonitorTableModel model = null;
        private JTable table = null;
        private JScrollPane scroll = null;
        private JPanel list_panel = null;
        private JPanel list_buttons = null;
        private JButton remove_button = null;
        private JButton remove_all_button = null;
        private JButton filter_button = null;
        private JPanel details_panel = null;
        private JPanel details_header = null;
        private JSplitPane details_soap = null;
        private JPanel details_buttons = null;
        private JLabel details_time = null;
        private JLabel details_target = null;
        private JLabel details_status = null;
        private JLabel details_time_value = null;
        private JLabel details_target_value = null;
        private JLabel details_status_value = null;
        private EmptyBorder empty_border = null;
        private EtchedBorder etched_border = null;
        private JPanel request_panel = null;
        private JPanel response_panel = null;
        private JLabel request_label = null;
        private JLabel response_label = null;
        private SOAPMonitorTextArea request_text = null;
        private SOAPMonitorTextArea response_text = null;
        private JScrollPane request_scroll = null;
        private JScrollPane response_scroll = null;
        private JButton layout_button = null;
        private JSplitPane split = null;
        private JPanel status_area = null;
        private JPanel status_buttons = null;
        private JButton start_button = null;
        private JButton stop_button = null;
        private JLabel status_text = null;
        private JPanel status_text_panel = null;
        private SOAPMonitorFilter filter = null;
        private GridBagLayout details_header_layout = null;
        private GridBagConstraints details_header_constraints = null;
        private JCheckBox reflow_xml = null;

        public SOAPMonitorPage(String host_name) {
            this.host = host_name;
            this.filter = new SOAPMonitorFilter();
            this.etched_border = new EtchedBorder();
            this.model = new SOAPMonitorTableModel();
            this.table = new JTable(this.model);
            this.table.setSelectionMode(0);
            this.table.setRowSelectionInterval(0, 0);
            this.table.setPreferredScrollableViewportSize(new Dimension(600, 96));
            this.table.getSelectionModel().addListSelectionListener(this);
            this.scroll = new JScrollPane(this.table);
            this.remove_button = new JButton("Remove");
            this.remove_button.addActionListener(this);
            this.remove_button.setEnabled(false);
            this.remove_all_button = new JButton("Remove All");
            this.remove_all_button.addActionListener(this);
            this.filter_button = new JButton("Filter ...");
            this.filter_button.addActionListener(this);
            this.list_buttons = new JPanel();
            this.list_buttons.setLayout(new FlowLayout());
            this.list_buttons.add(this.remove_button);
            this.list_buttons.add(this.remove_all_button);
            this.list_buttons.add(this.filter_button);
            this.list_panel = new JPanel();
            this.list_panel.setLayout(new BorderLayout());
            this.list_panel.add((Component)this.scroll, "Center");
            this.list_panel.add((Component)this.list_buttons, "South");
            this.list_panel.setBorder(this.empty_border);
            this.details_time = new JLabel("Time: ", 4);
            this.details_target = new JLabel("Target Service: ", 4);
            this.details_status = new JLabel("Status: ", 4);
            this.details_time_value = new JLabel();
            this.details_target_value = new JLabel();
            this.details_status_value = new JLabel();
            Dimension preferred_size = this.details_time.getPreferredSize();
            preferred_size.width = 1;
            this.details_time.setPreferredSize(preferred_size);
            this.details_target.setPreferredSize(preferred_size);
            this.details_status.setPreferredSize(preferred_size);
            this.details_time_value.setPreferredSize(preferred_size);
            this.details_target_value.setPreferredSize(preferred_size);
            this.details_status_value.setPreferredSize(preferred_size);
            this.details_header = new JPanel();
            this.details_header_layout = new GridBagLayout();
            this.details_header.setLayout(this.details_header_layout);
            this.details_header_constraints = new GridBagConstraints();
            this.details_header_constraints.fill = 1;
            this.details_header_constraints.weightx = 0.5;
            this.details_header_layout.setConstraints(this.details_time, this.details_header_constraints);
            this.details_header.add(this.details_time);
            this.details_header_layout.setConstraints(this.details_time_value, this.details_header_constraints);
            this.details_header.add(this.details_time_value);
            this.details_header_layout.setConstraints(this.details_target, this.details_header_constraints);
            this.details_header.add(this.details_target);
            this.details_header_constraints.weightx = 1.0;
            this.details_header_layout.setConstraints(this.details_target_value, this.details_header_constraints);
            this.details_header.add(this.details_target_value);
            this.details_header_constraints.weightx = 0.5;
            this.details_header_layout.setConstraints(this.details_status, this.details_header_constraints);
            this.details_header.add(this.details_status);
            this.details_header_layout.setConstraints(this.details_status_value, this.details_header_constraints);
            this.details_header.add(this.details_status_value);
            this.details_header.setBorder(this.etched_border);
            this.request_label = new JLabel("SOAP Request", 0);
            this.request_text = new SOAPMonitorTextArea();
            this.request_text.setEditable(false);
            this.request_scroll = new JScrollPane(this.request_text);
            this.request_panel = new JPanel();
            this.request_panel.setLayout(new BorderLayout());
            this.request_panel.add((Component)this.request_label, "North");
            this.request_panel.add((Component)this.request_scroll, "Center");
            this.response_label = new JLabel("SOAP Response", 0);
            this.response_text = new SOAPMonitorTextArea();
            this.response_text.setEditable(false);
            this.response_scroll = new JScrollPane(this.response_text);
            this.response_panel = new JPanel();
            this.response_panel.setLayout(new BorderLayout());
            this.response_panel.add((Component)this.response_label, "North");
            this.response_panel.add((Component)this.response_scroll, "Center");
            this.details_soap = new JSplitPane(1);
            this.details_soap.setTopComponent(this.request_panel);
            this.details_soap.setRightComponent(this.response_panel);
            this.details_soap.setResizeWeight(0.5);
            this.details_panel = new JPanel();
            this.layout_button = new JButton("Switch Layout");
            this.layout_button.addActionListener(this);
            this.reflow_xml = new JCheckBox("Reflow XML text");
            this.reflow_xml.addActionListener(this);
            this.details_buttons = new JPanel();
            this.details_buttons.setLayout(new FlowLayout());
            this.details_buttons.add(this.reflow_xml);
            this.details_buttons.add(this.layout_button);
            this.details_panel.setLayout(new BorderLayout());
            this.details_panel.add((Component)this.details_header, "North");
            this.details_panel.add((Component)this.details_soap, "Center");
            this.details_panel.add((Component)this.details_buttons, "South");
            this.details_panel.setBorder(this.empty_border);
            this.split = new JSplitPane(0);
            this.split.setTopComponent(this.list_panel);
            this.split.setRightComponent(this.details_panel);
            this.start_button = new JButton("Start");
            this.start_button.addActionListener(this);
            this.stop_button = new JButton("Stop");
            this.stop_button.addActionListener(this);
            this.status_buttons = new JPanel();
            this.status_buttons.setLayout(new FlowLayout());
            this.status_buttons.add(this.start_button);
            this.status_buttons.add(this.stop_button);
            this.status_text = new JLabel();
            this.status_text.setBorder(new BevelBorder(1));
            this.status_text_panel = new JPanel();
            this.status_text_panel.setLayout(new BorderLayout());
            this.status_text_panel.add((Component)this.status_text, "Center");
            this.status_text_panel.setBorder(this.empty_border);
            this.status_area = new JPanel();
            this.status_area.setLayout(new BorderLayout());
            this.status_area.add((Component)this.status_buttons, "West");
            this.status_area.add((Component)this.status_text_panel, "Center");
            this.status_area.setBorder(this.etched_border);
            this.setLayout(new BorderLayout());
            this.add((Component)this.split, "Center");
            this.add((Component)this.status_area, "South");
        }

        public String getHost() {
            return this.host;
        }

        public void setStatus(String txt) {
            this.status_text.setForeground(Color.black);
            this.status_text.setText("  " + txt);
        }

        public void setErrorStatus(String txt) {
            this.status_text.setForeground(Color.red);
            this.status_text.setText("  " + txt);
        }

        public void start() {
            String codehost = SOAPMonitorApplet.this.getCodeBase().getHost();
            if (this.socket == null) {
                try {
                    this.socket = new Socket(codehost, SOAPMonitorApplet.this.port);
                    this.out = new ObjectOutputStream(this.socket.getOutputStream());
                    this.out.flush();
                    this.in = new ObjectInputStream(this.socket.getInputStream());
                    new Thread(this).start();
                }
                catch (Exception e) {
                    System.out.println("Exception! " + e.toString());
                    e.printStackTrace();
                    this.setErrorStatus("The SOAP Monitor is unable to communcate with the server.");
                    this.socket = null;
                }
            }
            if (this.socket != null) {
                this.start_button.setEnabled(false);
                this.stop_button.setEnabled(true);
                this.setStatus("The SOAP Monitor is started.");
            }
        }

        public void stop() {
            if (this.socket != null) {
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    this.out = null;
                }
                if (this.in != null) {
                    try {
                        this.in.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    this.in = null;
                }
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    this.socket = null;
                }
            }
            this.start_button.setEnabled(true);
            this.stop_button.setEnabled(false);
            this.setStatus("The SOAP Monitor is stopped.");
        }

        public void run() {
            while (this.socket != null) {
                try {
                    Integer message_type = (Integer)this.in.readObject();
                    switch (message_type) {
                        case 0: {
                            Long id = (Long)this.in.readObject();
                            String target = (String)this.in.readObject();
                            String soap = (String)this.in.readObject();
                            SOAPMonitorData data = new SOAPMonitorData(id, target, soap);
                            this.model.addData(data);
                            int selected = this.table.getSelectedRow();
                            if (selected != 0 || !this.model.filterMatch(data)) break;
                            this.valueChanged(null);
                            break;
                        }
                        case 1: {
                            int row;
                            Long id = (Long)this.in.readObject();
                            String soap = (String)this.in.readObject();
                            SOAPMonitorData data = this.model.findData(id);
                            if (data == null) break;
                            boolean update_needed = false;
                            int selected = this.table.getSelectedRow();
                            if (selected == 0) {
                                update_needed = true;
                            }
                            if ((row = this.model.findRow(data)) != -1 && row == selected) {
                                update_needed = true;
                            }
                            data.setSOAPResponse(soap);
                            this.model.updateData(data);
                            if (!update_needed) break;
                            this.valueChanged(null);
                        }
                    }
                }
                catch (Exception e) {
                    if (!this.stop_button.isEnabled()) continue;
                    this.stop();
                    this.setErrorStatus("The server communication has been terminated.");
                }
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            int row = this.table.getSelectedRow();
            if (row > 0) {
                this.remove_button.setEnabled(true);
            } else {
                this.remove_button.setEnabled(false);
            }
            if (row == 0 && (row = this.model.getRowCount() - 1) == 0) {
                row = -1;
            }
            if (row == -1) {
                this.details_time_value.setText("");
                this.details_target_value.setText("");
                this.details_status_value.setText("");
                this.request_text.setText("");
                this.response_text.setText("");
            } else {
                SOAPMonitorData soap = this.model.getData(row);
                this.details_time_value.setText(soap.getTime());
                this.details_target_value.setText(soap.getTargetService());
                this.details_status_value.setText(soap.getStatus());
                if (soap.getSOAPRequest() == null) {
                    this.request_text.setText("");
                } else {
                    this.request_text.setText(soap.getSOAPRequest());
                    this.request_text.setCaretPosition(0);
                }
                if (soap.getSOAPResponse() == null) {
                    this.response_text.setText("");
                } else {
                    this.response_text.setText(soap.getSOAPResponse());
                    this.response_text.setCaretPosition(0);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.remove_button) {
                int row = this.table.getSelectedRow();
                this.model.removeRow(row);
                this.table.clearSelection();
                this.table.repaint();
                this.valueChanged(null);
            }
            if (e.getSource() == this.remove_all_button) {
                this.model.clearAll();
                this.table.setRowSelectionInterval(0, 0);
                this.table.repaint();
                this.valueChanged(null);
            }
            if (e.getSource() == this.filter_button) {
                this.filter.showDialog();
                if (this.filter.okPressed()) {
                    this.model.setFilter(this.filter);
                    this.table.repaint();
                }
            }
            if (e.getSource() == this.start_button) {
                this.start();
            }
            if (e.getSource() == this.stop_button) {
                this.stop();
            }
            if (e.getSource() == this.layout_button) {
                this.details_panel.remove(this.details_soap);
                this.details_soap.removeAll();
                this.details_soap = this.details_soap.getOrientation() == 1 ? new JSplitPane(0) : new JSplitPane(1);
                this.details_soap.setTopComponent(this.request_panel);
                this.details_soap.setRightComponent(this.response_panel);
                this.details_soap.setResizeWeight(0.5);
                this.details_panel.add((Component)this.details_soap, "Center");
                this.details_panel.validate();
                this.details_panel.repaint();
            }
            if (e.getSource() == this.reflow_xml) {
                this.request_text.setReflowXML(this.reflow_xml.isSelected());
                this.response_text.setReflowXML(this.reflow_xml.isSelected());
            }
        }
    }
}

