package de.dass_it.vanhelsing.gui;

import java.lang.reflect.Method;
import java.util.ArrayList;

import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import de.dass_it.vanhelsing.gui.items.*;
import de.dass_it.www.vanhelsing.*;
import de.dass_it.www.vanhelsing.VanHelsingCallbackHandler.*;
import de.dass_it.www.vanhelsing.VanHelsingStub.*;

/*
 * List all Bacula configuration components by name
 */
public class ConfigurationBean extends TreeNavigation {

	private DefaultTreeModel tree;
	private ArrayList<ViewItem> selectedObject;

	public ConfigurationBean() {
		init();
	}
	private void init(){
		DefaultMutableTreeNode root = new DefaultMutableTreeNode();
		DefaultMutableTreeNode header;
		DefaultMutableTreeNode leaf;
		String type;
		ListResourcesType lrt;
		GetResourceType grt;
		DefaultMutableTreeNode myNode;
		ResourceInfo[] ri;
		SimpleResource sr;
		// ((ClientItem)selectedObject).setName("ClientNameTest");

		Client c = new Client();
		String[] nodes = { "Director", "Storage", "Catalog", "Autochanger",
				"Client", "FileSet", "FDClient", "Schedule", "SDStorage",
				"Console", "Catalog", "SDDevice", "Job", "JobDefs", "Messages",
				"Pool" };
		// String[] nodes = {"Client"};
		setTree(super.createTree(root, nodes, "Configuration"));

		// forall header wird eine ResourceList[] angefragt
		for (int i = 0; i < tree.getChildCount(root); i++) {
			header = (DefaultMutableTreeNode) tree.getChild(root, i);
			type = ((UserObjectItemType) header.getUserObject())
					.getUserObject().getResType();
			lrt = new ListResourcesType();
			lrt.setDirector("bacula-dir");
			lrt.setResourceType(type);
			ri = c.getListResources(lrt);
			if (ri == null || ri.length == 0)
				continue;
			for (int j = 0; j < ri.length; j++) {
				// myNode = null;
				myNode = addNode(header, type, ri[j]);
				// Node mit Daten befüllen
				grt = new GetResourceType();
				grt.setDirector(lrt.getDirector());
				grt.setResId(ri[j].getResId());
				sr = c.getSimpleResource(grt);
				myNode = addNode(myNode, type, sr.getResourceAttributeType());
				if (myNode != null) {
					header.add(myNode);
				}
			}
		}
		/*
		 * for (int i = 0; i < tree.getChildCount(root); i++){ header =
		 * (DefaultMutableTreeNode)tree.getChild(root, i);
		 * 
		 * for (int j = 0; j < tree.getChildCount(header); j++){ leaf =
		 * (DefaultMutableTreeNode)tree.getChild(header, j); type =
		 * ((UserObjectItemType
		 * )leaf.getUserObject()).getUserObject().getResType(); grt = new
		 * GetResourceType(); grt.setDirector("bacula-dir");
		 * grt.setResId(((ItemType
		 * )(((UserObjectItemType)leaf.getUserObject()).getUserObject
		 * ())).getResId()); sr = c.getSimpleResource(grt);
		 * sr.getResourceAttributeType(); myNode = addNode(leaf, type,
		 * sr.getResourceAttributeType()); if (myNode != null){
		 * leaf.add(myNode); }
		 * 
		 * } }
		 */

	}


	public void userObjectItemNodeSelected(ActionEvent ae) {
		DefaultMutableTreeNode node;
		UserObjectItem userObject;
		selectedObject = new ArrayList<ViewItem>();
		String Id = BeanUtil.getRequestParameter("userObject.resId");
		node = getNode(Id, tree);
		String type = ((UserObjectItem) ((UserObjectItemType) node
				.getUserObject()).getUserObject()).getResType();
		String resName = ((ItemType)((UserObjectItem) ((UserObjectItemType) node
				.getUserObject()).getUserObject())).getResName();
		String director = ((ItemType)((UserObjectItem) ((UserObjectItemType) node
				.getUserObject()).getUserObject())).getDirector();
		String classType = "de.dass_it.vanhelsing.gui.items." + type + "Item";
		// Daten aus dem UserObjectItem extrahieren
		try {
			UserObjectItem item = ((UserObjectItemType) (node.getUserObject()))
					.getUserObject();
			Class c = ((UserObjectItemType) (node.getUserObject()))
					.getUserObject().getClass();
			Method[] m = c.getDeclaredMethods();
			String keyValue;
			String key;
			ViewItem vi;
			for (Method n : m) {
				if (n.getName().startsWith("get")) {
					keyValue = (String) n.invoke(item, (Object[]) null);
					if (keyValue == null)
						continue;
					key = n.getName().substring(3);
					vi = new ViewItem();
					vi.setResId(new Integer(Id));
					vi.setKey(key);
					vi.setKeyValue(keyValue);
					vi.setResType(type);
					vi.setResName(resName);
					vi.setDirector(director);
					vi.setRendererFlag(BeanUtil.getRenderer(type, key));
					System.err.println(vi.getRenderer());
					System.err.println(vi.getInputText());
					System.err.println(vi.getSelectOneMenu()+"\n\n");
					selectedObject.add(vi);
				}
				selectedObject.trimToSize();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	public void newResourceButtonListener(ActionEvent ae){
		
	}
	public void userObjectItemOptionSelected(ValueChangeEvent vce){
		
	}
	
	public void saveButtonListener(ActionEvent ae) {
		Client c = new Client();
		ResourceInfo ri = new ResourceInfo();
		SetSimpleResourceResponse s2r2;
		ri.setDirector( selectedObject.get(0).getDirector() );
		ri.setResId( selectedObject.get(0).getResId() );
		ri.setResName( selectedObject.get(0).getResName() );
		ri.setResType( selectedObject.get(0).getResType() );
		// ResourceAttribute
		String key, value;
		ResourceAttributeType[] ra = new ResourceAttributeType[selectedObject.size()];
		for (int i = 0; i < selectedObject.size(); i++) {
			key = selectedObject.get(i).getKey();
			value = selectedObject.get(i).getKeyValue();
			ra[i] = new ResourceAttributeType();
			ra[i].setKey(key);
			ra[i].setValue(value);
		}
		SetSimpleResource s2r = new SetSimpleResource();
		s2r.setResAttribute(ra);
		s2r.setResInfo(ri);
		s2r2 = c.setSimpleResource(s2r);
		System.err.println("Status setSimpleRes: "+s2r2.getStatus());
		BeanUtil.setErrorMessage(null, "Status setSimpleRessource: "+s2r2.getStatus());
		
		/*String status = s2r2.getStatus();
		if (selectedObject.get(0) != null){
			selectedObject.get(0).setResId(s2r2.getResId());
		}*/
		// TODO: write ResId to selectedObject
		// selectedObject.get(0).setResId(grt.getResId());
		// valueChangeEffect.setFired(false);
	}

	public void setTree(DefaultTreeModel tree) {
		this.tree = tree;
	}

	public DefaultTreeModel getTree() {
		return tree;
	}

	public ArrayList<ViewItem> getSelectedObject() {
		return selectedObject;
	}

	public void setSelectedObject(ArrayList<ViewItem> selectedObject) {
		this.selectedObject = selectedObject;
	}

}
