package de.dass_it.vanhelsing.gui;



import javax.faces.application.FacesMessage;
import javax.faces.application.FacesMessage.Severity;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import java.util.ResourceBundle;
import java.util.Locale;



//import org.apache.log4j.Logger;

/*
 * Helper class to encapsulate common bean methods.
 * Managed beans will extend this class either directly or 
 * via a data structure helper class like TreeNavigation
 */
public class BeanUtil {
	//Logging
    
	//protected final Logger logger = Logger.getLogger(this.getClass());
    
	//Messagebundles
	public static String getProperty(String key){
		String s = PropertyBundle.getProperty(key);
		return s;
	}
	
	public static String[] getProperties(String key){
		String[] suffix = {"ref", "type", "required", "def"};
		String[] bundle = new String[4];
		for (int i = 0; i < 4; i++) {
			bundle[i] = BeanUtil.getProperty(key+"."+suffix[i]);
		}
		return bundle;
	}
	public static boolean getRequired(String type, String key){
		String s = getFieldProperty(type, key, 2);
		if (s.equals("true") )return true;
		return false;
	}
	public static String getDataType(String type, String key){
		return getFieldProperty(type, key, 1);
	}
	//getRenderer returns rendererType based on properties
	public static String getRenderer(String type, String key){
		return getFieldProperty(type, key, 0);
	}
	public static String getFieldProperty(String type, String key, int i){
		String daemon = "director";
		String res = "inputText";
		if (type.startsWith("SD")){
			daemon = "storagedaemon";
		}
		if (type.startsWith("FD")){
			daemon = "filedaemon";
		}
		type = type.toLowerCase();
		key = key.toLowerCase();
		key = key.replaceAll(" ", "");
		String result[] = getProperties((daemon+"."+type+"."+key));
		if (i == 0) {
			if (result[1].equals("boolean")){
				return "radioGroup"; 
			}
			if (!(result[0].equals("0"))){
				return "selectOneMenu";
			}		
			return res;
		}
		if (i == 2) return result[2];
		if (i == 1) return result[1];
		if (i == 3) return result[3];
		return res;
	}
	
    //Statusmeldungen an den Client
    public static void setInfoMessage(String client, String message){
    	FacesContext.getCurrentInstance().addMessage(client, new FacesMessage(FacesMessage.SEVERITY_INFO, message, message));
    }
    public static void setErrorMessage(String client, String message){
    	FacesContext.getCurrentInstance().addMessage(client, new FacesMessage(FacesMessage.SEVERITY_ERROR, message, message));
    }
    
	//Linkout to Bacula documentation
	//ListItemsConfigView
	//ListItemsTopologyView
	//ListItemsJobSchedule
	
	//GetParameterFromContext
	public static String getRequestParameter(String name){
		return (String) FacesContext.getCurrentInstance().getExternalContext().getRequestParameterMap().get(name);
	}
	
	public static String getAccessType(String type){
		if (type.equals("jobdefs")) return "job";
		return type;
	}
	
}
