# -*- coding: utf-8 -*-
# $Id: $
#
# automatically generate the database model for web2py 
# from the info we already have for dassModus
#
#
# we do have every information about the bacula configuration files.
# we now have to create the following database model:
# a table for each main configuration file:
# dird_conf,
# filed_conf,
# stored_conf,
# bconsole_conf
#
# in each bacula configuration file, we have two classes of ressources: 
# 1.: Ressources, that can only appear once
#   here, we can just create a reference to a table containing the 
#   configuration options of this ressource.
#  
#
#
# 2.: Ressources, that can appear multiple times
#   we need a table between the bacula configuration and the list of ressources.
#
#   here, we have a link to a list of ressources
#  example: a dird can have multiple client ressources:
#
#
#
#
         

from nosferatu.config_classes import *
from resource import Resource
from nosferatu import prettynames, auto_configrules

#single_res=['dir_res']
## this ressource can only appear once in the dir conf
#for res in single_res:
#  print """db.define_table('dird_conf-%s',
#  Field('name','string'),
#  format='%%s(name)s)'
#  """ % (res)

#print """db.define_table('dird_conf',
#  Field('name','string'),"""
#for res in single_res:
#  print "  Field('dird_conf-%s', reference dird_conf-%s)," % (res,res )
#print "  format='%(name)s')"



def item2field(confshort, item):
    if item.name == 'where' : # where cannot be a column name in sqlite
      item.name = 'where_'
    
    if item.name in INTERNALLY_REFERENCED_ITEMS:
      refname = item.name
      if item.name.endswith('pool'):
        refname = 'pool'
      print '### ' + refname
      
      fieldtype = 'reference %s_conf__%s'  %  (confshort,refname)
      defaultvalue = 0
      return """ Field('%s','%s', default=%s), """ %(item.name, fieldtype , defaultvalue)
    else:
      fieldtype = 'string'
      defaultvalue = item.defaultvalue
      if item.type == "store_bool":
        fieldtype = "boolean"
        #print "#####%s %s %s" % (item.name, item.defaultvalue, defaultvalue) 
        return """ Field('%s','%s', default=%s), """ %(item.name, fieldtype , defaultvalue)
      return """ Field('%s','%s', default='%s'), """ %(item.name, fieldtype , defaultvalue)






dir_res_list = list()
 
confshort = 'dird'
for res in auto_configrules.dird_resources:
  res_name = res[0]
  res_type = res[1]
  res_items = res[2]
  dir_res_list.append(res_name)
  print 
  #print res_name
  print """db.define_table('%s_conf__%s',  """ % (confshort,res_name)
  for item in res_items:
    item.required=False
    item.printall=True
    print item2field(confshort,item)
  print """ format='%(name)s')"""


confshort = 'stored'
stor_res_list = list()
for res in auto_configrules.stored_resources:
  res_name = res[0]
  res_type = res[1]
  res_items = res[2]
  stor_res_list.append(res_name)
  print 
  #print res_name
  print """db.define_table('%s_conf__%s',  """ % (confshort,res_name)
  for item in res_items:
    item.required=False
    item.printall=True
    print item2field(confshort,item)
  print """ format='%(name)s')"""


confshort = 'filed'
filed_res_list = list()
for res in auto_configrules.filed_resources:
  res_name = res[0]
  res_type = res[1]
  res_items = res[2]
  filed_res_list.append(res_name)
  print 
  #print res_name
  print """db.define_table('%s_conf__%s',  """ % (confshort,res_name)
  for item in res_items:
    item.required=False
    item.printall=True
    print item2field(confshort,item)
  print """ format='%(name)s')"""

confshort = 'cons'
cons_res_list = list()
for res in auto_configrules.console_resources:
  res_name = res[0]
  res_type = res[1]
  res_items = res[2]
  cons_res_list.append(res_name)
  print 
  #print res_name
  print """db.define_table('%s_conf__%s',  """ % (confshort,res_name)
  for item in res_items:
    item.required=False
    item.printall=True
    print item2field(confshort,item)
  print """ format='%(name)s')"""





for res in dir_res_list:   
  print """db.define_table('dird_conf__%s_link',
  Field('%s','reference dird_conf__%s'),
  format = '%%(id)s')
    """ % (res,res,res)
print """db.define_table('dird_conf',
  Field('name','string'),"""

for res in dir_res_list:
  print "  Field('dird_conf__%s', 'reference dird_conf__%s_link')," % (res,res )
print """  format='%(name)s')
"""



for res in stor_res_list:   
  print """db.define_table('stord_conf__%s_link',
  Field('%s','reference stord_conf__%s'),
  format = '%%(id)s')
    """ % (res,res,res)
print """db.define_table('stord_conf',
  Field('name','string'),"""

for res in stor_res_list:
  print "  Field('stord_conf__%s', 'reference stord_conf__%s_link')," % (res,res )
print """  format='%(name)s')
"""



for res in filed_res_list:   
  print """db.define_table('filed_conf__%s_link',
  Field('%s','reference filed_conf__%s'),
  format = '%%(id)s')
    """ % (res,res,res)
print """db.define_table('filed_conf',
  Field('name','string'),"""

for res in filed_res_list:
  print "  Field('filed_conf__%s', 'reference filed_conf__%s_link')," % (res,res )
print """  format='%(name)s')
"""




for res in cons_res_list:   
  print """db.define_table('cons_conf__%s_link',
  Field('%s','reference cons_conf__%s'),
  format = '%%(id)s')
    """ % (res,res,res)
print """db.define_table('cons_conf',
  Field('name','string'),"""

for res in cons_res_list:
  print "  Field('cons_conf__%s', 'reference cons_conf__%s_link')," % (res,res )
print """  format='%(name)s')
"""


#Abhängikeiten:
# dird 
#  job/jobdefs   ->client
#                -> pool
#                -> fileset
#                -> pool
#                -> messages
#                -> schedule
#                -> storage
#                -> jobdefs
#                -> job
# messages   -> catalog
# counter    -> catalog
# storage    -> device
# director   -> messages
# client     -> catalog
# pool       -> catalog, storage


# Reihenfolge:
# storage->catalog->fileset->pool->jobdefs->client->
# counter->messages->job->director



# stored:
# autochanger -> device
# storage  -> messages
# messages -> catalog

# filed:
# messages -> catalog
# client/filedaemon -> messages





